/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import io.qameta.allure.bamboo.AllureSettingsManager;
import io.qameta.allure.bamboo.BambooExecutablesManager;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AllureBuildConfigurator
extends BaseConfigurablePlugin
implements MiscellaneousPlanConfigurationPlugin {
    private BambooExecutablesManager executablesManager;
    private AllureSettingsManager settingsManager;

    public boolean isApplicableTo(@NotNull ImmutablePlan plan) {
        return PlanClassHelper.isChain((ImmutablePlan)plan);
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection collection = super.validate(buildConfiguration);
        if (buildConfiguration.getBoolean("custom.allure.config.enabled") && StringUtils.isEmpty((CharSequence)buildConfiguration.getString("custom.allure.config.executable"))) {
            collection.addError("custom.allure.config.executable", "Cannot be empty!");
        }
        return collection;
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        super.prepareConfigObject(buildConfiguration);
        if (buildConfiguration.getProperty("custom.allure.config.enabled") == null) {
            Optional.ofNullable(this.settingsManager).map(AllureSettingsManager::getSettings).ifPresent(settings -> buildConfiguration.setProperty("custom.allure.config.enabled", (Object)settings.isEnabledByDefault()));
        }
        if (buildConfiguration.getProperty("custom.allure.config.failed.only") == null) {
            buildConfiguration.setProperty("custom.allure.config.failed.only", (Object)Boolean.TRUE);
        }
        if (buildConfiguration.getProperty("custom.allure.config.executable") == null) {
            Optional.ofNullable(this.executablesManager).flatMap(BambooExecutablesManager::getDefaultAllureExecutable).ifPresent(executable -> buildConfiguration.setProperty("custom.allure.config.executable", executable));
        }
    }

    public void setSettingsManager(AllureSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setExecutablesManager(BambooExecutablesManager executablesManager) {
        this.executablesManager = executablesManager;
    }
}

