/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.plugins.PostChainAction;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.spring.container.ContainerManager;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.qameta.allure.bamboo.AllureArtifactsManager;
import io.qameta.allure.bamboo.AllureBuildConfig;
import io.qameta.allure.bamboo.AllureBuildResult;
import io.qameta.allure.bamboo.AllureExecutable;
import io.qameta.allure.bamboo.AllureExecutableProvider;
import io.qameta.allure.bamboo.AllureGlobalConfig;
import io.qameta.allure.bamboo.AllureSettingsManager;
import io.qameta.allure.bamboo.BambooExecutablesManager;
import io.qameta.allure.bamboo.info.AddExecutorInfo;
import io.qameta.allure.bamboo.info.allurewidgets.summary.Summary;
import io.qameta.allure.bamboo.util.Downloader;
import io.qameta.allure.bamboo.util.ExceptionUtil;
import io.qameta.allure.bamboo.util.FileStringReplacer;
import io.qameta.allure.bamboo.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureBuildCompleteAction
extends BaseConfigurablePlugin
implements PostChainAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureBuildCompleteAction.class);
    private static final String HISTORY_JSON = "history.json";
    private static final String HISTORY = "history";
    private static final List<String> HISTORY_FILES = Arrays.asList("history.json", "history-trend.json", "categories-trend.json", "duration-trend.json");
    private final AllureExecutableProvider allureExecutable;
    private final AllureSettingsManager settingsManager;
    private final AllureArtifactsManager artifactsManager;
    private final BambooExecutablesManager executablesManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final AdministrationConfiguration adminConfiguration;

    public AllureBuildCompleteAction(AllureExecutableProvider allureExecutable, AllureSettingsManager settingsManager, AllureArtifactsManager artifactsManager, BambooExecutablesManager executablesManager, ResultsSummaryManager resultsSummaryManager) {
        this.allureExecutable = allureExecutable;
        this.settingsManager = settingsManager;
        this.artifactsManager = artifactsManager;
        this.executablesManager = executablesManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.adminConfiguration = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull ImmutableChain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull ChainExecution chainExecution) {
        BuildDefinition buildDef = chain.getBuildDefinition();
        AllureGlobalConfig globalConfig = this.settingsManager.getSettings();
        AllureBuildConfig buildConfig = AllureBuildConfig.fromContext(buildDef.getCustomConfiguration());
        boolean allureEnabled = buildConfig.isEnabled() || !buildConfig.isEnabledSet() && globalConfig.isEnabledByDefault();
        boolean isEnabledForFailedOnly = buildConfig.isOnlyForFailed();
        if (!allureEnabled || isEnabledForFailedOnly && !chainResultsSummary.isFailed()) {
            return;
        }
        File artifactsTempDir = com.google.common.io.Files.createTempDir();
        File allureReportDir = new File(com.google.common.io.Files.createTempDir(), "report");
        Map customBuildData = chainResultsSummary.getCustomBuildData();
        try {
            String executable = Optional.ofNullable(buildConfig.getExecutable()).orElse(this.executablesManager.getDefaultAllureExecutable().orElseThrow(() -> new RuntimeException("Could not find default Allure executable! Please configure plugin properly!")));
            LOGGER.info("Allure Report is enabled for {}", (Object)chain.getName());
            LOGGER.info("Trying to get executable by name {} for {}", (Object)executable, (Object)chain.getName());
            AllureExecutable allure = this.allureExecutable.provide(globalConfig, executable).orElseThrow(() -> new RuntimeException("Failed to find Allure executable by name " + executable));
            AllureExecutable allureTmp = allure.getCopy();
            LOGGER.info("Starting artifacts downloading into {} for {}", (Object)artifactsTempDir.getPath(), (Object)chain.getName());
            Collection<Path> artifactsPaths = this.artifactsManager.downloadAllArtifactsTo(chainResultsSummary, artifactsTempDir, buildConfig.getArtifactName());
            if (artifactsTempDir.list().length == 0) {
                AllureBuildResult.allureBuildResult(false, "Build result does not have any uploaded artifacts!").dumpToCustomData(customBuildData);
            } else {
                LOGGER.info("Starting allure generate into {} for {}", (Object)allureReportDir.getPath(), (Object)chain.getName());
                this.prepareResults(artifactsPaths.stream().map(Path::toFile).collect(Collectors.toList()), chain, chainExecution);
                if (globalConfig.isCustomLogoEnabled()) {
                    allureTmp.setCustomLogo(buildConfig.getCustomLogoUrl());
                }
                allureTmp.generate(artifactsPaths, allureReportDir.toPath());
                this.finalizeReport(allureReportDir, chainExecution.getPlanResultKey().getBuildNumber(), chain.getBuildName());
                ZipUtil.zipFolder(allureReportDir.toPath(), allureReportDir.toPath().resolve("report.zip"));
                LOGGER.info("Allure has been generated successfully for {}", (Object)chain.getName());
                this.artifactsManager.uploadReportArtifacts(chain, chainResultsSummary, allureReportDir).ifPresent(result -> result.dumpToCustomData(customBuildData));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to build allure report for {}", (Object)chain.getName(), (Object)e);
            AllureBuildResult.allureBuildResult(false, ExceptionUtil.stackTraceToString(e)).dumpToCustomData(customBuildData);
        }
        finally {
            org.apache.commons.io.FileUtils.deleteQuietly((File)artifactsTempDir);
            org.apache.commons.io.FileUtils.deleteQuietly((File)allureReportDir);
        }
    }

    private void finalizeReport(@NotNull File allureReportDir, int buildNumber, String buildName) throws IOException {
        Path widgetsJsonPath = Paths.get(allureReportDir.getAbsolutePath(), new String[0]).resolve("widgets").resolve("summary.json");
        JsonMapper mapper = new JsonMapper();
        Summary summary = (Summary)mapper.readValue(widgetsJsonPath.toFile(), Summary.class);
        summary.setReportName(String.format("Build %s - %s", buildNumber, buildName));
        mapper.writeValue(widgetsJsonPath.toFile(), (Object)summary);
        Path appJsPath = Paths.get(allureReportDir.getAbsolutePath(), new String[0]).resolve("app.js");
        FileStringReplacer.replaceInFile(appJsPath, Pattern.compile(">Allure</span>", 14), ">&nbsp;</span>");
        Path indexHtmlPath = Paths.get(allureReportDir.getAbsolutePath(), new String[0]).resolve("index.html");
        FileStringReplacer.replaceInFile(indexHtmlPath, Pattern.compile("<title>.*</title>", 14), String.format("<title> Build %s - %s </title>", buildNumber, buildName));
    }

    private void prepareResults(List<File> artifactsTempDirs, @NotNull ImmutableChain chain, @NotNull ChainExecution chainExecution) {
        this.copyHistory(artifactsTempDirs, chain.getPlanKey().getKey(), chainExecution.getPlanResultKey().getBuildNumber());
        this.addExecutorInfo(artifactsTempDirs, chain, chainExecution.getPlanResultKey().getBuildNumber());
    }

    private void copyHistory(@NotNull List<File> artifactsTempDirs, String planKey, int buildNumber) {
        Path tmpDirToDownloadHistory = com.google.common.io.Files.createTempDir().toPath();
        this.getLastBuildNumberWithHistory(planKey, buildNumber).ifPresent(buildId -> this.copyHistoryFiles(planKey, tmpDirToDownloadHistory, (Integer)buildId));
        artifactsTempDirs.forEach(artifactsTempDir -> {
            try {
                FileUtils.copyDirectory((File)tmpDirToDownloadHistory.toFile(), (File)artifactsTempDir.toPath().resolve(HISTORY).toFile());
            }
            catch (IOException e) {
                LOGGER.error("Failed to copy history files from temp directory into artifacts directory", (Throwable)e);
            }
        });
        org.apache.commons.io.FileUtils.deleteQuietly((File)tmpDirToDownloadHistory.toFile());
    }

    private void copyHistoryFiles(String planKey, Path historyDir, Integer buildNumber) {
        HISTORY_FILES.forEach(historyFile -> this.copyArtifactToHistoryFolder(historyDir, (String)historyFile, planKey, buildNumber));
    }

    private Optional<Integer> getLastBuildNumberWithHistory(String planKey, int buildNumber) {
        ResultsSummary lastBuild;
        int currentBuild = buildNumber;
        do {
            if (!Objects.isNull(lastBuild = this.resultsSummaryManager.findLastBuildResultBefore(planKey, currentBuild))) continue;
            return Optional.empty();
        } while (!this.historyArtifactExists(planKey, currentBuild = lastBuild.getBuildNumber()));
        return Optional.of(currentBuild);
    }

    private boolean historyArtifactExists(String planKey, int buildId) {
        String artifactUrl = this.getHistoryArtifactUrl(HISTORY_JSON, planKey, buildId);
        JsonMapper mapper = new JsonMapper();
        try {
            Path historyTmpFile = Files.createTempFile(HISTORY, ".json", new FileAttribute[0]);
            Downloader.download(new URL(artifactUrl), historyTmpFile);
            mapper.readValue(historyTmpFile.toFile(), Object.class);
            return true;
        }
        catch (Exception e) {
            LOGGER.info("Cannot connect to artifact or the artifact is not valid {}.", (Object)artifactUrl, (Object)e);
            return false;
        }
    }

    private void copyArtifactToHistoryFolder(Path historyFolder, String fileName, String planKey, int buildId) {
        try (InputStream inputStream = this.getArtifactContent(fileName, planKey, buildId);){
            Files.createDirectories(historyFolder, new FileAttribute[0]);
            Files.copy(inputStream, historyFolder.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Could not copy file {}", (Object)fileName);
        }
    }

    private InputStream getArtifactContent(String fileName, String planKey, int buildId) throws IOException {
        URL artifactUrl = new URL(this.getHistoryArtifactUrl(fileName, planKey, buildId));
        URLConnection uc = artifactUrl.openConnection();
        return uc.getInputStream();
    }

    @NotNull
    private String getHistoryArtifactUrl(String fileName, String planKey, int buildId) {
        return String.format("%s/plugins/servlet/allure/report/%s/%s/history/%s", this.getBambooBaseUrl(), planKey, buildId, fileName);
    }

    private void addExecutorInfo(@NotNull List<File> artifactsTempDirs, @NotNull ImmutableChain chain, int buildNumber) {
        String rootUrl = this.getBambooBaseUrl();
        String buildName = chain.getBuildName();
        String buildUrl = String.format("%s/browse/%s-%s", rootUrl, chain.getPlanKey().getKey(), buildNumber);
        String reportUrl = String.format("%s/plugins/servlet/allure/report/%s/%s", rootUrl, chain.getPlanKey().getKey(), buildNumber);
        AddExecutorInfo executorInfo = new AddExecutorInfo(rootUrl, Integer.toString(buildNumber), buildName, buildUrl, reportUrl);
        artifactsTempDirs.forEach(executorInfo::invoke);
    }

    @NotNull
    private String getBambooBaseUrl() {
        if (this.adminConfiguration != null) {
            return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.adminConfiguration.getBaseUrl()}) ? this.adminConfiguration.getBaseUrl() : "";
        }
        return "";
    }
}

