/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManagerUtils;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooExecutablesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BambooExecutablesManager.class);
    private final CapabilitySetManager capabilitySetManager;

    public BambooExecutablesManager(CapabilitySetManager capabilitySetManager) {
        this.capabilitySetManager = capabilitySetManager;
    }

    List<String> getAllureExecutables() {
        return this.getCapabilityKeys().stream().filter(capKey -> capKey.toLowerCase().startsWith("system.builder.allure".toLowerCase())).map(this::getCapability).filter(Optional::isPresent).map(Optional::get).map(Capability::getKey).map(cap -> cap.replaceFirst("system.builder.allure.", "")).collect(Collectors.toList());
    }

    Optional<String> getDefaultAllureExecutable() {
        return this.getAllureExecutables().stream().findAny();
    }

    Optional<String> getExecutableByName(String executableName) {
        LOGGER.debug("Trying to find a capability by executable name '{}'", (Object)executableName);
        return this.getCapabilityKeys().stream().filter(capKey -> {
            String[] strings = capKey.split("\\.", 4);
            boolean matches = strings.length == 4 && executableName.equals(strings[3]);
            LOGGER.debug("Checking key '{}' to matches executable name '{}'={}...", new Object[]{capKey, executableName, matches});
            return matches;
        }).findFirst().map(this::getCapability).filter(Optional::isPresent).map(Optional::get).map(Capability::getValue);
    }

    void addDefaultAllureExecutableCapability() {
        Optional.ofNullable(CapabilitySetManagerUtils.getSharedCapabilitySet((CapabilitySetManager)this.capabilitySetManager, LocalCapabilitySet.class)).ifPresent(capSet -> {
            String key = String.format("%s.allure-%s", "system.builder.allure", "2.21.0");
            CapabilityImpl capability = new CapabilityImpl(key, "/tmp/allure/2.21.0");
            capSet.addCapability((Capability)capability);
            this.capabilitySetManager.saveCapabilitySet(capSet);
        });
    }

    @NotNull
    private Collection<String> getCapabilityKeys() {
        return this.capabilitySetManager.getSystemCapabilityKeys("builder", false);
    }

    private Optional<Capability> getCapability(String capabilityKey) {
        return Optional.ofNullable(Objects.requireNonNull(this.capabilitySetManager.getSharedLocalCapabilitySet()).getCapability(capabilityKey));
    }
}

