/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import java.io.Serializable;
import java.util.Map;
import org.sonatype.aether.util.StringUtils;

class AllureBuildResult
implements Serializable {
    private final boolean success;
    private String artifactHandlerClass;
    private String failureDetails;

    AllureBuildResult(boolean success) {
        this.success = success;
    }

    AllureBuildResult(boolean success, String failureDetails) {
        this.success = success;
        this.failureDetails = failureDetails;
    }

    static AllureBuildResult allureBuildResult(boolean success, String failureDetails) {
        return new AllureBuildResult(success, failureDetails);
    }

    static AllureBuildResult fromCustomData(Map<String, String> data) {
        AllureBuildResult result = new AllureBuildResult(Boolean.parseBoolean(data.get("custom.allure.build.report.success")));
        result.setArtifactHandlerClass(data.get("custom.allure.build.report.artifact.handler"));
        result.setFailureDetails(data.get("custom.allure.build.report.output"));
        return result;
    }

    void dumpToCustomData(Map<String, String> data) {
        data.put("custom.allure.build.report.artifact.handler", this.artifactHandlerClass);
        data.put("custom.allure.build.report.success", String.valueOf(this.success));
        data.put("custom.allure.build.report.output", this.failureDetails);
    }

    AllureBuildResult withHandlerClass(String artifactHandlerClass) {
        this.setArtifactHandlerClass(artifactHandlerClass);
        return this;
    }

    String getArtifactHandlerClass() {
        return this.artifactHandlerClass;
    }

    void setArtifactHandlerClass(String artifactHandlerClass) {
        this.artifactHandlerClass = artifactHandlerClass;
    }

    boolean isSuccess() {
        return this.success;
    }

    String getFailureDetails() {
        return this.failureDetails;
    }

    void setFailureDetails(String failureDetails) {
        this.failureDetails = failureDetails;
    }

    boolean hasInfo() {
        return !StringUtils.isEmpty((String)this.failureDetails) || !StringUtils.isEmpty((String)this.artifactHandlerClass);
    }
}

