/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import io.qameta.allure.bamboo.AllureArtifactsManager;
import io.qameta.allure.bamboo.AllureBuildResult;
import io.qameta.allure.bamboo.AllurePluginException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.util.StringUtils;

public class AllureReportServlet
extends HttpServlet {
    private static final Pattern URL_PATTERN = Pattern.compile(".*/plugins/servlet/allure/report/([^/]{2,})/([^/]+)/?(.*)");
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureReportServlet.class);
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String FAILED_TO_SEND_FILE_OF_ALLURE_REPORT = "Failed to send file {} of Allure Report ";
    private final transient AllureArtifactsManager artifactsManager;
    private final ResultsSummaryManager resultsSummaryManager;

    @Inject
    public AllureReportServlet(AllureArtifactsManager artifactsManager, ResultsSummaryManager resultsSummaryManager) {
        this.artifactsManager = artifactsManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public static Pattern getUrlPattern() {
        return URL_PATTERN;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.getArtifactUrl(request, response).ifPresent(file -> {
            try (InputStream inputStream = new URL((String)file).openStream();){
                this.setResponseHeaders(response, (String)file);
                IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                LOGGER.error(FAILED_TO_SEND_FILE_OF_ALLURE_REPORT, file);
            }
        });
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.getArtifactUrl(request, response).ifPresent(file -> {
            try (InputStream inputStream = new URL((String)file).openStream();){
                this.setResponseHeaders(response, (String)file);
            }
            catch (IOException e) {
                response.setStatus(404);
                LOGGER.error(FAILED_TO_SEND_FILE_OF_ALLURE_REPORT, file);
            }
        });
    }

    private void setResponseHeaders(HttpServletResponse response, String fileUrl) throws IOException {
        try {
            response.setStatus(200);
            URI file = new URL(fileUrl).toURI();
            String mimeType = Optional.ofNullable(this.getServletContext().getMimeType(fileUrl)).orElse(Files.probeContentType(Paths.get(file.getPath(), new String[0])));
            String charsetPostfix = Stream.of("application", "text").anyMatch(mimeType::contains) ? ";charset=utf-8" : "";
            response.setHeader(CONTENT_TYPE, mimeType + charsetPostfix);
            response.setHeader(CONTENT_DISPOSITION, "inline; filename=\"" + Paths.get(file.getPath(), new String[0]).getFileName().toString() + "\"");
        }
        catch (URISyntaxException e) {
            throw new AllurePluginException("Unexpected error", e);
        }
    }

    private Optional<String> getArtifactUrl(HttpServletRequest request, HttpServletResponse response) {
        Matcher matcher = URL_PATTERN.matcher(request.getRequestURI());
        if (matcher.matches()) {
            response.setHeader("X-Frame-Options", "ALLOWALL");
            String planKey = matcher.group(1);
            String buildNumber = matcher.group(2);
            String filePath = matcher.group(3);
            if (this.wasUploadSuccess(response, planKey, Integer.parseInt(buildNumber))) {
                return this.artifactsManager.getArtifactUrl(planKey, buildNumber, filePath);
            }
        } else {
            LOGGER.info("Path {} does not match pattern", (Object)request.getRequestURI());
        }
        return Optional.empty();
    }

    private boolean wasUploadSuccess(HttpServletResponse response, String planKey, int buildNumber) {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)planKey, (int)buildNumber);
        ResultsSummary results = this.resultsSummaryManager.getResultsSummary(planResultKey);
        if (results != null) {
            AllureBuildResult uploadResult = AllureBuildResult.fromCustomData(results.getCustomBuildData());
            if (!uploadResult.isSuccess()) {
                this.uploadResultWasNotSuccess(response, uploadResult);
                return false;
            }
            return true;
        }
        return false;
    }

    private void uploadResultWasNotSuccess(HttpServletResponse response, AllureBuildResult uploadResult) {
        String errorMessage = StringUtils.isEmpty((String)uploadResult.getFailureDetails()) ? "Unknown error has occurred during Allure Build. Please refer the server logs for details." : "Something went wrong with Allure Report generation. Here are some details: \n" + uploadResult.getFailureDetails();
        try {
            response.setHeader(CONTENT_TYPE, "text/plain");
            response.setHeader("Content-Length", String.valueOf(errorMessage.length()));
            response.setHeader(CONTENT_DISPOSITION, "inline");
            response.getWriter().write(errorMessage);
        }
        catch (IOException e) {
            LOGGER.error("Failed to render error of Allure Report build ", (Throwable)e);
        }
    }
}

