/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.qameta.allure.bamboo.AllureCommandLineSupport;
import io.qameta.allure.bamboo.AllureGenerateResult;
import io.qameta.allure.bamboo.AllurePluginException;
import io.qameta.allure.bamboo.info.AllurePlugins;
import io.qameta.allure.bamboo.util.FileStringReplacer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AllureExecutable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureExecutable.class);
    private static final String BASH_CMD = "/bin/bash";
    private final Path cmdPath;
    private final AllureCommandLineSupport cmdLine;

    AllureExecutable(Path cmdPath, AllureCommandLineSupport commandLine) {
        this.cmdPath = cmdPath;
        this.cmdLine = commandLine;
    }

    @Nonnull
    AllureGenerateResult generate(Collection<Path> sourceDirs, Path targetDir) {
        try {
            String output;
            LinkedList<String> args = new LinkedList<String>(Arrays.asList("generate", "-o", targetDir.toString()));
            args.addAll(sourceDirs.stream().map(Path::toString).collect(Collectors.toList()));
            if (this.cmdLine.isUnix() && this.cmdLine.hasCommand(BASH_CMD)) {
                args.addFirst(this.cmdPath.toString());
                output = this.cmdLine.runCommand(BASH_CMD, args.toArray(new String[0]));
            } else {
                output = this.cmdLine.runCommand(this.cmdPath.toString(), args.toArray(new String[0]));
            }
            LOGGER.info(output);
            return this.cmdLine.parseGenerateOutput(output);
        }
        catch (Exception e) {
            throw new AllurePluginException("Failed to generate allure report", e);
        }
    }

    public void setCustomLogo(String logoUrl) {
        String pluginName = "custom-logo-plugin";
        String allureConfigFileName = "allure.yml";
        String cssFileName = "styles.css";
        Path rootPath = this.cmdPath.getParent().getParent();
        Path configFolder = rootPath.resolve("config");
        Path logoPluginFolder = rootPath.resolve("plugins").resolve("custom-logo-plugin").resolve("static");
        YAMLMapper objectMapper = new YAMLMapper();
        try {
            File configFile = configFolder.resolve("allure.yml").toFile();
            AllurePlugins ap = (AllurePlugins)objectMapper.readValue(configFile, AllurePlugins.class);
            if (ap.registerPlugin("custom-logo-plugin")) {
                objectMapper.writeValue(configFile, (Object)ap);
            }
            URL srcLogoUrl = UriBuilder.fromPath((String)logoUrl).build(new Object[0]).toURL();
            FileStringReplacer.replaceInFile(logoPluginFolder.resolve("styles.css"), Pattern.compile("url\\('.+'\\)", 14), "url(" + srcLogoUrl.toString() + ")");
            FileStringReplacer.replaceInFile(logoPluginFolder.resolve("styles.css"), Pattern.compile("(?<=\\s )left", 14), "center");
            FileStringReplacer.replaceInFile(logoPluginFolder.resolve("styles.css"), Pattern.compile("10px", 14), "0px");
        }
        catch (IOException e) {
            LOGGER.error(e.toString());
            throw new AllurePluginException("Unexpected error", e);
        }
    }

    Path getCmdPath() {
        return this.cmdPath;
    }
}

