/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.jetbrains.annotations.NotNull;

public class ZipUtil {
    public static void unzip(@NotNull Path zipFilePath, String outputDir) throws IOException, ArchiveException {
        ArchiveEntry entry;
        ArchiveStreamFactory asf = new ArchiveStreamFactory();
        InputStream zipStream = Files.newInputStream(zipFilePath, new OpenOption[0]);
        ArchiveInputStream ais = asf.createArchiveInputStream("zip", zipStream);
        while ((entry = ais.getNextEntry()) != null) {
            Path entryPath = Paths.get(outputDir, entry.getName());
            File entryFile = entryPath.toFile();
            if (!entry.isDirectory()) {
                File parentEntryFile = entryFile.getParentFile();
                if (parentEntryFile.isDirectory() && !parentEntryFile.mkdirs() && !parentEntryFile.exists()) {
                    throw new IOException("The directory: " + parentEntryFile.getPath() + " couldn't be created successfully");
                }
                OutputStream outputStream = Files.newOutputStream(entryPath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)ais, (OutputStream)outputStream);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                    continue;
                }
            }
            if (entryFile.mkdirs() || entryFile.exists()) continue;
            throw new IOException("The directory: " + entryFile.getPath() + " couldn't be created successfully");
        }
    }

    public static void zipFolder(@NotNull Path srcFolder, @NotNull Path targetDir) throws IOException {
        Path zipReportTmpDir = Files.createTempDirectory("tmp_allure_report", new FileAttribute[0]);
        Path zipReport = zipReportTmpDir.resolve("report.zip");
        try (ZipFile zp = new ZipFile(zipReport.toFile());){
            zp.addFolder(srcFolder.toFile());
        }
        Files.move(zipReport, targetDir, StandardCopyOption.REPLACE_EXISTING);
    }
}

