/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import io.qameta.allure.bamboo.AllureConstants;
import io.qameta.allure.bamboo.AllureGlobalConfig;
import io.qameta.allure.bamboo.AllureSettingsManager;
import java.util.Map;

public class ConfigureAllureReportAction
extends GlobalAdminAction
implements Preparable {
    private final AllureSettingsManager settingsManager;
    private AllureGlobalConfig config;

    public ConfigureAllureReportAction(AllureSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public String execute() throws Exception {
        this.settingsManager.saveSettings(AllureGlobalConfig.fromContext(ActionParamsUtils.getStringArrayMap()));
        return super.execute();
    }

    public void validate() {
        super.validate();
        Map valuesMap = ActionParamsUtils.getStringArrayMap();
        if (!valuesMap.containsKey(AllureConstants.ALLURE_CONFIG_DOWNLOAD_URL)) {
            this.addActionError(this.getText("allure.config.download.url.error.required"));
        }
        if (!valuesMap.containsKey(AllureConstants.ALLURE_CONFIG_LOCAL_STORAGE)) {
            this.addActionError(this.getText("allure.config.download.local.storage.required"));
        }
    }

    private AllureGlobalConfig getAllureConfig() {
        return this.settingsManager.getSettings();
    }

    public void prepare() throws Exception {
        this.config = this.getAllureConfig();
        this.getAllureConfig().toContext(ActionContext.getContext().getContextMap());
    }

    public AllureGlobalConfig getConfig() {
        return this.config;
    }
}

