/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import io.qameta.allure.bamboo.AllureConstants;
import io.qameta.allure.bamboo.AllureGlobalConfig;

public class AllureSettingsManager {
    private final PluginSettings settings;

    public AllureSettingsManager(PluginSettingsFactory settingsFactory) {
        this.settings = settingsFactory.createGlobalSettings();
    }

    AllureGlobalConfig getSettings() {
        String downloadEnabled = (String)this.settings.get(AllureConstants.ALLURE_CONFIG_DOWNLOAD_ENABLED);
        String customLogoEnabled = (String)this.settings.get(AllureConstants.ALLURE_CUSTOM_LOGO_ENABLED);
        String enableByDefault = (String)this.settings.get(AllureConstants.ALLURE_CONFIG_ENABLED_BY_DEFAULT);
        String downloadBaseUrl = (String)this.settings.get(AllureConstants.ALLURE_CONFIG_DOWNLOAD_URL);
        String downloadCliBaseUrl = (String)this.settings.get(AllureConstants.ALLURE_CONFIG_DOWNLOAD_CLI_URL);
        String localStorage = (String)this.settings.get(AllureConstants.ALLURE_CONFIG_LOCAL_STORAGE);
        return new AllureGlobalConfig(downloadEnabled, enableByDefault, downloadBaseUrl, localStorage, downloadCliBaseUrl, customLogoEnabled);
    }

    void saveSettings(AllureGlobalConfig config) {
        this.settings.put(AllureConstants.ALLURE_CONFIG_DOWNLOAD_ENABLED, (Object)String.valueOf(config.isDownloadEnabled()));
        this.settings.put(AllureConstants.ALLURE_CUSTOM_LOGO_ENABLED, (Object)String.valueOf(config.isCustomLogoEnabled()));
        this.settings.put(AllureConstants.ALLURE_CONFIG_DOWNLOAD_URL, (Object)String.valueOf(config.getDownloadBaseUrl()));
        this.settings.put(AllureConstants.ALLURE_CONFIG_LOCAL_STORAGE, (Object)String.valueOf(config.getLocalStoragePath()));
        this.settings.put(AllureConstants.ALLURE_CONFIG_ENABLED_BY_DEFAULT, (Object)String.valueOf(config.isEnabledByDefault()));
    }
}

