/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import io.qameta.allure.bamboo.AllureConstants;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.sonatype.aether.util.StringUtils;

class AllureGlobalConfig
implements Serializable {
    private static final String DEFAULT_DOWNLOAD_BASE_URL = "https://github.com/allure-framework/allure2/releases/download/";
    private static final String DEFAULT_CLI_BASE_URL = "https://repo.maven.apache.org/maven2/io/qameta/allure/";
    public static final String DEFAULT_LOCAL_STORAGE_PATH = new File(SystemUtils.getJavaIoTmpDir(), "allure-reports").getPath();
    private final boolean downloadEnabled;
    private final boolean customLogoEnabled;
    private final boolean enabledByDefault;
    private final String localStoragePath;
    private final String downloadBaseUrl;
    private final String downloadCliBaseUrl;

    AllureGlobalConfig() {
        this(Boolean.TRUE.toString(), Boolean.FALSE.toString(), DEFAULT_DOWNLOAD_BASE_URL, DEFAULT_LOCAL_STORAGE_PATH, DEFAULT_CLI_BASE_URL, Boolean.TRUE.toString());
    }

    AllureGlobalConfig(String downloadEnabled, String enabledByDefault, String downloadBaseUrl, String localStoragePath, String cmdLineUrl, String customLogoEnable) {
        this.downloadEnabled = StringUtils.isEmpty((String)downloadEnabled) ? Boolean.TRUE : Boolean.parseBoolean(downloadEnabled);
        this.enabledByDefault = StringUtils.isEmpty((String)enabledByDefault) ? Boolean.FALSE : Boolean.parseBoolean(enabledByDefault);
        this.downloadBaseUrl = StringUtils.isEmpty((String)downloadBaseUrl) ? DEFAULT_DOWNLOAD_BASE_URL : downloadBaseUrl;
        this.downloadCliBaseUrl = StringUtils.isEmpty((String)cmdLineUrl) ? DEFAULT_CLI_BASE_URL : cmdLineUrl;
        this.localStoragePath = StringUtils.isEmpty((String)localStoragePath) ? DEFAULT_LOCAL_STORAGE_PATH : localStoragePath;
        this.customLogoEnabled = StringUtils.isEmpty((String)customLogoEnable) ? Boolean.TRUE : Boolean.parseBoolean(customLogoEnable);
    }

    @NotNull
    static AllureGlobalConfig fromContext(Map context) {
        return new AllureGlobalConfig(AllureGlobalConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_DOWNLOAD_ENABLED, Boolean.FALSE.toString()), AllureGlobalConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_ENABLED_BY_DEFAULT, Boolean.FALSE.toString()), AllureGlobalConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_DOWNLOAD_URL, DEFAULT_DOWNLOAD_BASE_URL), AllureGlobalConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_LOCAL_STORAGE, DEFAULT_LOCAL_STORAGE_PATH), AllureGlobalConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_DOWNLOAD_CLI_URL, DEFAULT_CLI_BASE_URL), AllureGlobalConfig.getSingleValue(context, AllureConstants.ALLURE_CUSTOM_LOGO_ENABLED, Boolean.FALSE.toString()));
    }

    @Nullable
    private static String getSingleValue(Map context, String key, String defaultVal) {
        return Optional.ofNullable(context.get(key)).map(value -> value instanceof String[] ? ((String[])value)[0] : (String)value).orElse(defaultVal);
    }

    void toContext(@NotNull Map<String, Object> context) {
        context.put(AllureConstants.ALLURE_CONFIG_DOWNLOAD_ENABLED, this.isDownloadEnabled());
        context.put(AllureConstants.ALLURE_CONFIG_ENABLED_BY_DEFAULT, this.isEnabledByDefault());
        context.put(AllureConstants.ALLURE_CONFIG_DOWNLOAD_URL, this.getDownloadBaseUrl());
        context.put(AllureConstants.ALLURE_CONFIG_DOWNLOAD_CLI_URL, this.getDownloadCliBaseUrl());
        context.put(AllureConstants.ALLURE_CONFIG_LOCAL_STORAGE, this.getLocalStoragePath());
        context.put(AllureConstants.ALLURE_CUSTOM_LOGO_ENABLED, this.isCustomLogoEnabled());
    }

    boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    boolean isCustomLogoEnabled() {
        return this.customLogoEnabled;
    }

    String getDownloadBaseUrl() {
        return this.downloadBaseUrl;
    }

    String getDownloadCliBaseUrl() {
        return this.downloadCliBaseUrl;
    }

    public String getLocalStoragePath() {
        return this.localStoragePath;
    }
}

