/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import io.qameta.allure.bamboo.AllureSettingsManager;
import io.qameta.allure.bamboo.util.Downloader;
import io.qameta.allure.bamboo.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AllureDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureDownloader.class);
    private final AllureSettingsManager settingsManager;

    AllureDownloader(AllureSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    Optional<Path> downloadAndExtractAllureTo(String allureHomeDir, String version) {
        return this.downloadAllure(version).map(zipFilePath -> {
            try {
                LOGGER.info("Extracting file {} to {}...", zipFilePath, (Object)allureHomeDir);
                String extractedDirName = "allure-" + version;
                File homeDir = new File(allureHomeDir);
                Path extractDir = zipFilePath.getParent();
                ZipUtil.unzip(zipFilePath, extractDir.toString());
                if (homeDir.exists()) {
                    LOGGER.info("Directory " + homeDir + " already exists, removing it..");
                    FileUtils.deleteQuietly((File)homeDir);
                }
                FileUtils.moveDirectory((File)extractDir.resolve(extractedDirName).toFile(), (File)homeDir);
                Path path = Paths.get(allureHomeDir, new String[0]);
                return path;
            }
            catch (IOException | ArchiveException e) {
                LOGGER.error("Failed to download and extract Allure of version {} to dir {}", new Object[]{version, allureHomeDir, e});
                Path path = null;
                return path;
            }
            finally {
                FileUtils.deleteQuietly((File)zipFilePath.toFile());
            }
        });
    }

    private Optional<Path> downloadAllure(String version) {
        try {
            URL[] urls;
            for (URL url : urls = this.buildAllureDownloadUrls(version)) {
                try {
                    Path downloadToFile = Files.createTempFile("allure", ".zip", new FileAttribute[0]);
                    LOGGER.info("Downloading allure.zip from {} to {}", (Object)url, (Object)downloadToFile);
                    return Downloader.download(url, downloadToFile);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to download from {}. Root cause : {}.", (Object)url, (Object)e.toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to download Allure of version {}", (Object)version, (Object)e);
        }
        return Optional.empty();
    }

    private URL[] buildAllureDownloadUrls(String version) throws MalformedURLException {
        URL gitUrl = UriBuilder.fromPath((String)this.settingsManager.getSettings().getDownloadBaseUrl()).path(version + "/allure-" + version + ".zip").build(new Object[0]).toURL();
        String binaryName = "allure-commandline";
        URL mavenUrl = UriBuilder.fromPath((String)this.settingsManager.getSettings().getDownloadCliBaseUrl()).path(binaryName + "/" + version + "/" + binaryName + "-" + version + ".zip").build(new Object[0]).toURL();
        return new URL[]{gitUrl, mavenUrl};
    }
}

