/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import io.qameta.allure.bamboo.AllureGenerateResult;
import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.buildobjects.process.ProcBuilder;
import org.jetbrains.annotations.NotNull;

public class AllureCommandLineSupport {
    private static final Pattern RESULT_TC_COUNT_REGEX = Pattern.compile(".+Found (\\d+) test cases.+", 32);
    private static final int GENERATE_TIMEOUT_MS = (int)TimeUnit.MINUTES.toMillis(10L);

    String runCommand(String cmd, String ... args) {
        return new ProcBuilder(cmd, new String[0]).withArgs(args).withTimeoutMillis(GENERATE_TIMEOUT_MS).run().getOutputString();
    }

    @NotNull
    AllureGenerateResult parseGenerateOutput(String output) {
        boolean success = true;
        Matcher matcher = RESULT_TC_COUNT_REGEX.matcher(output);
        if (matcher.matches()) {
            success = Integer.parseInt(matcher.group(1)) > 0;
        }
        return new AllureGenerateResult(output, success);
    }

    boolean isUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    boolean hasCommand(String command) {
        File cmdFile = Paths.get(command, new String[0]).toFile();
        return cmdFile.exists() && cmdFile.isFile();
    }
}

