/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import io.qameta.allure.bamboo.AllureConstants;
import java.io.Serializable;
import java.util.Map;
import org.sonatype.aether.util.StringUtils;

class AllureBuildResult
implements Serializable {
    private final boolean success;
    private String artifactHandlerClass;
    private String failureDetails;

    AllureBuildResult(boolean success) {
        this.success = success;
    }

    public AllureBuildResult(boolean success, String failureDetails) {
        this.success = success;
        this.failureDetails = failureDetails;
    }

    static AllureBuildResult allureBuildResult(boolean success, String failureDetails) {
        return new AllureBuildResult(success, failureDetails);
    }

    static AllureBuildResult fromCustomData(Map<String, String> data) {
        AllureBuildResult result = new AllureBuildResult(Boolean.parseBoolean(data.get(AllureConstants.ALLURE_BUILD_REPORT_SUCCESS)));
        result.setArtifactHandlerClass(data.get(AllureConstants.ALLURE_BUILD_REPORT_ARTIFACT_HANDLER));
        result.setFailureDetails(data.get(AllureConstants.ALLURE_BUILD_REPORT_FAILURE_DETAILS));
        return result;
    }

    void dumpToCustomData(Map<String, String> data) {
        data.put(AllureConstants.ALLURE_BUILD_REPORT_ARTIFACT_HANDLER, this.artifactHandlerClass);
        data.put(AllureConstants.ALLURE_BUILD_REPORT_SUCCESS, String.valueOf(this.success));
        data.put(AllureConstants.ALLURE_BUILD_REPORT_FAILURE_DETAILS, this.failureDetails);
    }

    AllureBuildResult withHandlerClass(String artifactHandlerClass) {
        this.setArtifactHandlerClass(artifactHandlerClass);
        return this;
    }

    String getArtifactHandlerClass() {
        return this.artifactHandlerClass;
    }

    void setArtifactHandlerClass(String artifactHandlerClass) {
        this.artifactHandlerClass = artifactHandlerClass;
    }

    boolean isSuccess() {
        return this.success;
    }

    String getFailureDetails() {
        return this.failureDetails;
    }

    void setFailureDetails(String failureDetails) {
        this.failureDetails = failureDetails;
    }

    boolean hasInfo() {
        return !StringUtils.isEmpty((String)this.failureDetails) || !StringUtils.isEmpty((String)this.artifactHandlerClass);
    }
}

