/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import io.qameta.allure.bamboo.AllureConstants;
import io.qameta.allure.bamboo.AllureSettingsManager;
import io.qameta.allure.bamboo.BambooExecutablesManager;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureBuildConfigurator
extends BaseConfigurablePlugin
implements MiscellaneousPlanConfigurationPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureBuildConfigurator.class);
    private BambooExecutablesManager executablesManager;
    private AllureSettingsManager settingsManager;

    public boolean isApplicableTo(@NotNull ImmutablePlan plan) {
        return PlanClassHelper.isChain((ImmutablePlan)plan);
    }

    public boolean isApplicableTo(@NotNull Plan plan) {
        return PlanClassHelper.isChain((ImmutablePlan)plan);
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection collection = super.validate(buildConfiguration);
        if (buildConfiguration.getBoolean(AllureConstants.ALLURE_CONFIG_ENABLED) && StringUtils.isEmpty(buildConfiguration.getString(AllureConstants.ALLURE_CONFIG_EXECUTABLE))) {
            collection.addError(AllureConstants.ALLURE_CONFIG_EXECUTABLE, "Cannot be empty!");
        }
        return collection;
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        super.prepareConfigObject(buildConfiguration);
        if (buildConfiguration.getProperty(AllureConstants.ALLURE_CONFIG_ENABLED) == null) {
            Optional.ofNullable(this.settingsManager).map(AllureSettingsManager::getSettings).ifPresent(settings -> buildConfiguration.setProperty(AllureConstants.ALLURE_CONFIG_ENABLED, (Object)settings.isEnabledByDefault()));
        }
        if (buildConfiguration.getProperty(AllureConstants.ALLURE_CONFIG_FAILED_ONLY) == null) {
            buildConfiguration.setProperty(AllureConstants.ALLURE_CONFIG_FAILED_ONLY, (Object)Boolean.TRUE);
        }
        if (buildConfiguration.getProperty(AllureConstants.ALLURE_CONFIG_EXECUTABLE) == null) {
            Optional.ofNullable(this.executablesManager).flatMap(BambooExecutablesManager::getDefaultAllureExecutable).ifPresent(executable -> buildConfiguration.setProperty(AllureConstants.ALLURE_CONFIG_EXECUTABLE, executable));
        }
    }

    public void setSettingsManager(AllureSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setExecutablesManager(BambooExecutablesManager executablesManager) {
        this.executablesManager = executablesManager;
    }
}

