/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import io.qameta.allure.bamboo.AllureConstants;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public class AllureBuildConfig
implements Serializable {
    private final boolean onlyForFailed;
    private final String executable;
    private final boolean enabled;
    private final String artifactName;
    private final String logoUrl;
    private static final String DEFAULT_ARTIFACT_NAME = "allure-results";
    public static final String DEFAULT_CUSTOM_LOGO_URL = "https://qameta.io/allure-report/img/reportlogo.svg";

    private AllureBuildConfig(String executable, String enabled, String onlyForFailed, String artifactName, String logoUrl) {
        this.onlyForFailed = StringUtils.isEmpty(onlyForFailed) ? Boolean.TRUE : Boolean.parseBoolean(onlyForFailed);
        this.enabled = StringUtils.isEmpty(enabled) ? Boolean.FALSE : Boolean.parseBoolean(enabled);
        this.executable = executable;
        this.artifactName = artifactName;
        UrlValidator urlValidator = new UrlValidator();
        this.logoUrl = urlValidator.isValid(logoUrl) ? logoUrl : DEFAULT_CUSTOM_LOGO_URL;
    }

    static AllureBuildConfig fromContext(Map<String, String> context) {
        return new AllureBuildConfig(AllureBuildConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_EXECUTABLE, null), AllureBuildConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_ENABLED, Boolean.FALSE.toString()), AllureBuildConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_FAILED_ONLY, Boolean.FALSE.toString()), AllureBuildConfig.getSingleValue(context, AllureConstants.ALLURE_CONFIG_ARTIFACT_NAME, DEFAULT_ARTIFACT_NAME), AllureBuildConfig.getSingleValue(context, AllureConstants.ALLURE_CUSTOM_LOGO_PATH, DEFAULT_CUSTOM_LOGO_URL));
    }

    @Nullable
    private static String getSingleValue(Map context, String key, String defaultVal) {
        return Optional.ofNullable(context.get(key)).map(value -> value instanceof String[] ? ((String[])value)[0] : (String)value).orElse(defaultVal);
    }

    boolean isOnlyForFailed() {
        return this.onlyForFailed;
    }

    boolean isEnabledSet() {
        return this.enabled;
    }

    public String getExecutable() {
        return this.executable;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getCustomLogoUrl() {
        return this.logoUrl;
    }
}

