/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.servlet;

import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.SAMLContext;
import eu.toimproveit.saml.SAMLLogoutHandler;
import eu.toimproveit.saml.SAMLUtils;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLLogoutServlet
extends HttpServlet {
    private final Log log = LogFactory.getLog(SAMLLogoutServlet.class);

    protected abstract SAMLConfig getSamlConfig();

    protected abstract void redirect(HttpServletRequest var1, HttpServletResponse var2);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.log.info("SAML Logout get");
        this.processLogout(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.log.info("SAML Logout post");
        this.processLogout(req, resp);
    }

    protected SAMLLogoutHandler getLogoutHandler() {
        return null;
    }

    private void processLogout(HttpServletRequest request, HttpServletResponse response) {
        boolean doRedirect = false;
        try {
            SAMLContext samlContext = new SAMLContext(this.getSamlConfig());
            SAMLUtils.resetLoggedIn(request, samlContext.getUserId(request, response));
            doRedirect = samlContext.processLogout(request, response, this.getLogoutHandler());
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        if (!response.isCommitted() && doRedirect) {
            this.redirect(request, response);
        }
    }
}

