/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.servlet;

import eu.toimproveit.avatar.service.AvatarService;
import eu.toimproveit.saml.Debugger;
import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.SAMLContext;
import eu.toimproveit.saml.SAMLCookieUtils;
import eu.toimproveit.saml.SAMLUser;
import eu.toimproveit.saml.SAMLUtils;
import eu.toimproveit.saml.model.SAMLSettings;
import eu.toimproveit.user.IGroup;
import eu.toimproveit.user.IUser;
import eu.toimproveit.user.IUserDirectory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLLoginServlet
extends HttpServlet {
    private Log log = LogFactory.getLog(SAMLLoginServlet.class);
    private SAMLConfig config;
    private SAMLCookieUtils samlCookieUtils;
    protected SAMLSettings settings;

    protected SAMLLoginServlet() {
    }

    protected AvatarService getAvatarService() {
        return null;
    }

    protected abstract SAMLConfig getSamlConfig();

    protected abstract SAMLCookieUtils getSamlCookieUtils();

    protected abstract boolean authenticateUser(HttpServletRequest var1, HttpServletResponse var2, IUser var3);

    protected abstract IUserDirectory getUserDirectory();

    public void init() throws ServletException {
        super.init();
        this.samlCookieUtils = this.getSamlCookieUtils();
        this.config = this.getSamlConfig();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.config.hasValidLicense()) {
                this.redirectError(request, response, "licenseError");
                return;
            }
            if (this.config.isInDebugMode()) {
                Debugger.debugRequest(request);
            }
            this.settings = this.config.getSettings();
            this.samlCookieUtils.setRedirectCookie(request, response);
            SAMLContext context = new SAMLContext(this.config);
            this.log.info("saml plugin : GET : sending authentication request");
            context.sendAuthenticationRequest(request, response);
        }
        catch (Throwable e) {
            this.log.error("saml login error : GET : ", e);
            this.redirectError(request, response, "general");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (!this.config.hasValidLicense()) {
                this.redirectError(req, resp, "licenseError");
                return;
            }
            if (this.config.isInDebugMode()) {
                Debugger.debugRequest(req);
            }
            this.settings = this.config.getSettings();
            this.log.info("saml plugin : doPost entry");
            SAMLContext context = new SAMLContext(this.config);
            SAMLUser user = context.getUser(req, resp);
            if (user == null) {
                this.log.info("saml plugin: user authentication failed");
                this.redirectError(req, resp, "plugin_exception");
                return;
            }
            this.log.info("saml plugin : authenticateUserAndLogin user :[" + user.getNameId() + "]");
            if (this.config.isInDebugMode() && this.settings.isCreateUser()) {
                try {
                    this.log.debug("userId:    [" + user.getUserId() + "]");
                    this.log.debug("userName:  [" + user.getUsername() + "]");
                    this.log.debug("email:     [" + user.getEmail() + "]");
                    String[] groups = user.getGroups();
                    if (groups != null) {
                        for (String group : groups) {
                            this.log.debug("group:    [" + group + "]");
                        }
                    } else {
                        this.log.debug("groups: null");
                    }
                    this.log.debug("thumbnail: [" + user.getAvatarBase64() + "]");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.authenticateUserAndLogin(req, resp, user);
        }
        catch (RuntimeException e) {
            try {
                this.log.error("saml plugin : authentication exception ", e);
                this.redirectError(req, resp, "plugin_exception");
                return;
            }
            catch (IOException e1) {
                throw new ServletException();
            }
        }
        catch (Exception e) {
            try {
                this.log.error("saml plugin : error ", e);
                this.redirectError(req, resp, "plugin_exception");
                return;
            }
            catch (IOException e1) {
                throw new ServletException();
            }
        }
    }

    protected void redirectError(HttpServletRequest req, HttpServletResponse resp, String error) throws IOException {
        resp.sendRedirect(req.getContextPath() + this.samlCookieUtils.getErrorRedirect() + "?samlerror=" + error);
    }

    private void authenticateUserAndLogin(HttpServletRequest request, HttpServletResponse response, SAMLUser samlUser) {
        this.log.info("authenticating with SAML : " + samlUser.toString());
        try {
            SAMLUtils.removeLoggedIn(request, samlUser.getUserId());
            if (!this.isAllowed(samlUser)) {
                this.redirectError(request, response, "user_not_allowed");
                return;
            }
            this.checkUser(samlUser);
            IUser user = this.getUser(samlUser);
            if (user == null) {
                this.log.warn("saml plugin : User Not Found : [" + samlUser.getNameId() + "]");
                this.redirectError(request, response, "user_not_found");
                return;
            }
            if (user.isActive()) {
                if (this.authenticateUser(request, response, user)) {
                    if (this.settings.isCreateUser()) {
                        AvatarService avatarService = this.getAvatarService();
                        String avatarBase64 = samlUser.getAvatarBase64();
                        if (avatarService != null && avatarBase64 != null) {
                            byte[] bytes = this.getOrDownloadAvatar(avatarBase64);
                            avatarService.setAvatar(samlUser.getUserId(), bytes);
                        }
                    }
                    SAMLUtils.setLoggedIn(request, samlUser.getUserId());
                    this.samlCookieUtils.sendRedirectUsingCookie(request, response);
                    return;
                }
            } else if (this.settings.isActivateUser()) {
                if (user.activate()) {
                    this.log.error("saml plugin: unable to activate user");
                    this.redirectError(request, response, "unable to activate user");
                    return;
                }
            } else {
                this.redirectError(request, response, "user_not_active");
                return;
            }
            this.log.warn("saml plugin : User Not Found : [" + samlUser.getNameId() + "]");
            this.redirectError(request, response, "user_not_found");
        }
        catch (Exception e) {
            this.log.error("saml plugin : error During authenticateUserAndLogin", e);
            throw new RuntimeException(e);
        }
    }

    private IUser getUser(SAMLUser samlUser) {
        IUserDirectory userDirectory = this.getUserDirectory();
        if (this.config.useEmailForLookup()) {
            return userDirectory.getUserByEmail(samlUser.getUserId());
        }
        return userDirectory.getUserByName(samlUser.getUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getOrDownloadAvatar(String value) {
        if (!value.toLowerCase().startsWith("http")) return Base64.getDecoder().decode(value);
        try {
            URL url = new URL(value);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = url.openStream();){
                int n;
                byte[] byteChunk = new byte[4096];
                while ((n = inputStream.read(byteChunk)) > 0) {
                    outputStream.write(byteChunk, 0, n);
                }
                byte[] byArray = outputStream.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                this.log.error("Error reading avatar", e);
                return Base64.getDecoder().decode(value);
            }
        }
        catch (MalformedURLException e) {
            this.log.error("Error avatar url", e);
        }
        return Base64.getDecoder().decode(value);
    }

    private boolean isAllowed(SAMLUser samlUser) {
        if (samlUser.isAllowedToUsergroups(this.settings.getAllowedUsergroups())) {
            return true;
        }
        this.log.warn("no usergroups allowed : [" + String.join((CharSequence)",", samlUser.getGroups()) + "] and [" + this.settings.getAllowedUsergroups() + "]");
        return false;
    }

    private void checkUser(SAMLUser samlUser) {
        if (!this.settings.isCreateUser()) {
            return;
        }
        IUser user = this.getUser(samlUser);
        if (user == null) {
            String[] groups;
            this.log.info("Creating user :" + samlUser.toString());
            String password = RandomStringUtils.random(16);
            IUserDirectory userDirectory = this.getUserDirectory();
            user = userDirectory.createUser(samlUser.getUserId(), samlUser.getUsername(), samlUser.getEmail(), password);
            if (user == null) {
                this.log.error("saml plugin : error During createUser");
            }
            if ((groups = samlUser.getGroups()) == null || groups.length == 0) {
                groups = this.settings.getDefaultUsergroup().split(",");
            }
            for (String groupName : groups) {
                if (this.settings.isCanCreateUsergroups()) {
                    this.log.info("saml plugin : create and add group:[" + groupName + "]");
                    if (this.createUserGroupAndAddUser(user, groupName)) continue;
                    this.log.error("saml plugin : error During createAndAddUsertoGroup group:[" + groupName + "]");
                    continue;
                }
                this.log.info("saml plugin : add group:[" + groupName + "]");
                if (this.addUserToGroup(user, groupName)) continue;
                this.log.error("saml plugin : error During addUsertoGroup group:[" + groupName + "]");
            }
        } else {
            String[] groups = samlUser.getGroups();
            if (this.settings.isCanRemoveUsergroups()) {
                this.log.info("saml plugin : check removing groups");
                if (!this.removeUserGroups(user, groups)) {
                    this.log.error("saml plugin : error During removeUserFromGroup");
                }
            } else {
                this.log.info("saml plugin : cannot removing groups");
            }
            if (this.settings.isCanUpdateUsergroups()) {
                for (String groupName : groups) {
                    if (!this.hasGroup(groupName)) {
                        if (!this.settings.isCanCreateUsergroups()) continue;
                        this.log.info("saml plugin : create group:[" + groupName + "]");
                        if (this.createUserGroupAndAddUser(user, groupName)) continue;
                        this.log.error("saml plugin : error During updateUsertoGroup group:[" + groupName + "]");
                        continue;
                    }
                    this.log.info("saml plugin : add group:[" + groupName + "]");
                    if (this.addUserToGroup(user, groupName)) continue;
                    this.log.error("saml plugin : error During updateUsertoGroup group:[" + groupName + "]");
                }
            }
            for (String groupName : groups = this.settings.getDefaultUsergroup().split(",")) {
                if (groupName.isEmpty()) continue;
                this.log.info("saml plugin: add user to default group:[" + groupName + "]");
                if (this.addUserToGroup(user, groupName)) continue;
                this.log.error("saml plugin: error during add to group:[" + groupName + "]");
            }
        }
    }

    private boolean removeUserGroups(IUser user, String[] exclude_groups) {
        IGroup[] user_groups;
        boolean successAll = true;
        IUserDirectory userDirectory = this.getUserDirectory();
        for (IGroup group : user_groups = userDirectory.getUserGroups(user)) {
            boolean success;
            boolean found = false;
            for (String exclude_group : exclude_groups) {
                if (!exclude_group.equals(group.getGroupName())) continue;
                found = true;
                break;
            }
            if (found || (success = userDirectory.removeUserFromGroup(user, group))) continue;
            this.log.error("saml plugin : error During removeUserFromGroup : user : " + user.getUserName() + " group: " + group.getGroupName());
            successAll = false;
        }
        return successAll;
    }

    private boolean hasGroup(String groupName) {
        IUserDirectory userDirectory = this.getUserDirectory();
        return userDirectory.getGroupByName(groupName) != null;
    }

    private boolean addUserToGroup(IUser user, String groupName) {
        IUserDirectory userDirectory = this.getUserDirectory();
        return userDirectory.addUserToGroup(user, groupName);
    }

    private boolean createUserGroupAndAddUser(IUser user, String groupName) {
        IUserDirectory userDirectory = this.getUserDirectory();
        return userDirectory.createGroupAndAddUser(user, groupName);
    }

    protected void setSAMLConfig(SAMLConfig config) {
        this.config = config;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.samlCookieUtils.sendRedirectUsingCookie(request, response);
        }
        catch (IOException e) {
            this.log.error("Error redirecting", e);
        }
    }
}

