/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.filter;

import eu.toimproveit.saml.filter.SAMLFilter;
import eu.toimproveit.saml.model.SAMLSettings;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class SAMLRestrictLoginFilter
extends SAMLFilter {
    protected abstract String getLoginUri(HttpServletRequest var1);

    protected boolean restrictLogin(HttpServletRequest request, String[] userGroups) {
        return false;
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        SAMLSettings settings = this.getSamlConfig().getSettings();
        String[] userGroups = settings.getRestrictedUserGroupList();
        if (this.getSamlConfig().hasValidLicense() && this.restrictLogin(request, userGroups)) {
            String url = this.getLoginUri(request);
            url = url.split("\\?")[0] + "?samlwarn=restrictSAML";
            response.sendRedirect(url);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

