/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.filter;

import eu.toimproveit.saml.SAMLUtils;
import eu.toimproveit.saml.filter.SAMLFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLAccessFilter
extends SAMLFilter {
    private final Log log = LogFactory.getLog(SAMLAccessFilter.class);

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.getSamlConfig().isSingleLogoutEnabled()) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (request != null && request.getPathInfo() != null && request.getPathInfo().endsWith("/saml/logout")) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String samlUserId = this.getSAMLUserId(request, response);
            if (SAMLUtils.loggedOut(request, samlUserId)) {
                String logoutUrl = this.getSamlConfig().getLogoutUrl((HttpServletRequest)servletRequest);
                logoutUrl = logoutUrl.contains("?") ? logoutUrl + "&loggedOut" : logoutUrl + "?loggedOut";
                this.log.info("SAML login no longer valid. Logging out ...");
                SAMLUtils.removeLoggedIn(request, samlUserId);
                ((HttpServletResponse)servletResponse).sendRedirect(logoutUrl);
            }
        }
        if (!servletResponse.isCommitted()) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

