/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.SAMLContext;
import java.io.ByteArrayInputStream;
import java.io.StringBufferInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLUtils {
    public static final String AUTH_USING_SAML = "eu.toimproveit.saml.saml-auth";
    private static final Log log = LogFactory.getLog(SAMLUtils.class);

    public static String getDefaultBaseURL(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        String scheme = request.getScheme();
        String servername = request.getServerName();
        int port = request.getServerPort();
        if ("https".equals(scheme) && port == 443) {
            port = -1;
        }
        if ("http".equals(scheme) && port == 80) {
            port = -1;
        }
        if (port == 443) {
            scheme = "https";
            port = -1;
        }
        sb.append(scheme).append("://").append(servername);
        if (port != -1) {
            sb.append(":").append(port);
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    public static X509Certificate generateX509Certificate(String certificateStr) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificateStr.trim().getBytes()));
    }

    public static String getX509Certificate(String xml) {
        Element documentElement = SAMLUtils.getDocumentElement("EntityDescriptor", xml);
        Element IDPSSODescriptor = SAMLUtils.getSubElement(documentElement, "IDPSSODescriptor", null, null);
        Element KeyDescriptor = null;
        try {
            KeyDescriptor = SAMLUtils.getSubElement(IDPSSODescriptor, "KeyDescriptor", "use", "encryption");
        }
        catch (Exception e) {
            KeyDescriptor = SAMLUtils.getSubElement(IDPSSODescriptor, "KeyDescriptor", "use", "signing");
        }
        Element KeyInfo2 = SAMLUtils.getSubElement(KeyDescriptor, "KeyInfo", null, null);
        Element X509Data2 = SAMLUtils.getSubElement(KeyInfo2, "X509Data", null, null);
        Element X509Certificate2 = SAMLUtils.getSubElement(X509Data2, "X509Certificate", null, null);
        String certificate = X509Certificate2.getTextContent();
        return "-----BEGIN CERTIFICATE-----\n" + certificate + "-----END CERTIFICATE-----\n";
    }

    public static Element getDocumentElement(String tagName, String xml) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new StringBufferInputStream(xml));
            Element element = document.getDocumentElement();
            String name = SAMLUtils.getTagName(element);
            if (name.equals(tagName)) {
                return element;
            }
            throw new RuntimeException("Cannot find documentelement [" + tagName + "] in xml\n" + xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Element getSubElement(Element element, String tagName, String withAttributeName, String withAttributeValue) {
        NodeList elements = element.getChildNodes();
        int len = elements.getLength();
        for (int i = 0; i < len; ++i) {
            Element subElement;
            String name;
            Node node = elements.item(i);
            if (node.getNodeType() != 1 || !(name = SAMLUtils.getTagName(subElement = (Element)node)).equals(tagName)) continue;
            if (withAttributeName == null) {
                return subElement;
            }
            if (!subElement.getAttribute(withAttributeName).equals(withAttributeValue)) continue;
            return subElement;
        }
        throw new RuntimeException("Cannot find element [" + tagName + "] in subElement");
    }

    private static String getTagName(Element subElement) {
        String name = subElement.getTagName();
        if (name.indexOf(58) > -1) {
            name = name.substring(name.indexOf(58) + 1);
        }
        return name;
    }

    public static void logout(SAMLConfig samlConfig, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (samlConfig.isSingleLogoutEnabled()) {
                SAMLContext samlContext = new SAMLContext(samlConfig);
                samlContext.sendLogoutRequest(request, response);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void removeLoggedIn(HttpServletRequest request, String samlUserId) {
        log.info("Remove SAML attr.");
        if (samlUserId == null) {
            return;
        }
        SAMLUtils.getContext(request).removeAttribute(SAMLUtils.getAttributeKey(samlUserId));
    }

    public static void setLoggedIn(HttpServletRequest request, String samlUserId) {
        log.info("Set SAML attr.");
        if (samlUserId == null) {
            return;
        }
        SAMLUtils.getContext(request).setAttribute(SAMLUtils.getAttributeKey(samlUserId), (Object)"true");
    }

    public static boolean loggedOut(HttpServletRequest request, String samlUserId) {
        log.info("Check SAML attr.");
        if (samlUserId == null) {
            return false;
        }
        String attribute = (String)SAMLUtils.getContext(request).getAttribute(SAMLUtils.getAttributeKey(samlUserId));
        return attribute != null && attribute.equalsIgnoreCase("false");
    }

    public static void resetLoggedIn(HttpServletRequest request, String samlUserId) {
        log.info("Unset SAML attr.");
        if (samlUserId == null) {
            return;
        }
        SAMLUtils.getContext(request).setAttribute(SAMLUtils.getAttributeKey(samlUserId), (Object)"false");
    }

    private static ServletContext getContext(HttpServletRequest request) {
        ServletContext context = request.getSession().getServletContext();
        log.info(String.format("Context: %s", context.getServletContextName()));
        return context;
    }

    private static String getAttributeKey(String samlUserId) {
        return String.format("%s-%s", AUTH_USING_SAML, samlUserId);
    }
}

