/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import com.google.gson.Gson;
import eu.toimproveit.saml.KeystoreUtils;
import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.SAMLUtils;
import eu.toimproveit.saml.model.SAMLSettings;
import eu.toimproveit.saml.model.SAMLUserMapping;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLSAMLConfig
implements SAMLConfig {
    private static final Log LOGGER = LogFactory.getLog(AbstractXMLSAMLConfig.class);
    public static final String FORCE_SAML_SETTING = "saml2.forceSAML";
    public static final String SHOW_BUTTON_SETTING = "saml2.showButton";
    public static final String BUTTON_TITLE_SETTING = "saml2.buttonTitle";
    public static final String SP_ENTITY_ID_SETTING = "saml2.spEntityId";
    public static final String IDP_XML_PROVIDER = "saml2.idpXMLProvider";
    public static final String IDP_XML = "saml2.idpXML";
    public static final String MAX_AUTHENTICATION_AGE = "saml2.maxAuthenticationAge";
    public static final String DISABLE_IN_RESPONSE_TO_CHECK = "saml2.disableInResponseToCheck";
    public static final String ACTIVATE_USER = "saml2.activateUser";
    public static final String CREATE_USER = "saml2.createUser";
    public static final String DEFAULT_USERGROUP = "saml2.defaultUsergroup";
    public static final String DISABLE_CHANGE_PASSWORD = "saml2.disableChangePassword";
    public static final String SAML_USER_MAPPING = "saml2.usermapping";
    public static final String RESPONSE_SKEW = "saml2.responseSkew";
    public static final String ALLOWED_USERGROUPS = "saml2.allowedUsergroups";
    public static final String CAN_CREATE_USERGROUPS = "saml2.canCreateUsergroups";
    public static final String CAN_UPDATE_USERGROUPS = "saml2.canUpdateUsergroups";
    public static final String CAN_REMOVE_USERGROUPS = "saml2.canRemoveUsergroups";
    public static final String SERVICE_DESK = "saml2.serviceDesk";
    public static final String HEADER_USER_NAME = "saml2.headerUserName";
    public static final String HEADER_TOKEN_NAME = "saml2.headerTokenName";
    public static final String HEADER_TOKEN_VALUE = "saml2.headerTokenValue";
    protected SAMLSettings samlSettings;

    public abstract Object getPluginSetting(String var1);

    public abstract void setPluginSetting(String var1, String var2);

    @Override
    public abstract String getBaseUrl();

    public abstract String getLicense();

    @Override
    public String getLogFilePath() {
        Path path = Paths.get(this.getSAMLHome().getAbsolutePath(), "log");
        path.toFile().mkdirs();
        return Paths.get(path.toString(), "saml-debug.log").toString();
    }

    @Override
    public boolean showTitle() {
        return true;
    }

    @Override
    public boolean activateUserAvailable() {
        return true;
    }

    @Override
    public boolean disableChangePasswordAvailable() {
        return true;
    }

    @Override
    public boolean serviceDeskAvailable() {
        return false;
    }

    @Override
    public boolean avatarServletAvailable() {
        return false;
    }

    @Override
    public boolean debugLogEnabled() {
        try {
            Logger rootLogger = Logger.getRootLogger();
            return rootLogger.getAppender("samlDebug") != null;
        }
        catch (NoClassDefFoundError error) {
            LOGGER.error(error.getMessage());
            return false;
        }
    }

    @Override
    public void enableDebugLog(boolean enable) {
        try {
            Enumeration loggers = LogManager.getCurrentLoggers();
            while (loggers.hasMoreElements()) {
                Logger logger = (Logger)loggers.nextElement();
                if (!logger.getName().startsWith("eu.toimproveit.saml") && !logger.getName().startsWith("org.opensaml") && !logger.getName().startsWith("org.springframework.security.saml")) continue;
                if (enable) {
                    logger.setLevel(Level.ALL);
                    continue;
                }
                logger.setLevel(Level.OFF);
            }
            this.enableLogAppender(enable);
        }
        catch (NoClassDefFoundError error) {
            LOGGER.error(error.getMessage());
        }
        LOGGER.info(String.format("Debug log enabled: %s", enable ? "YES" : "NO"));
    }

    private void enableLogAppender(boolean enable) {
        Logger rootLogger = Logger.getRootLogger();
        Appender samlDebug = rootLogger.getAppender("samlDebug");
        if (enable) {
            if (samlDebug != null) {
                return;
            }
            PatternLayout layout = new PatternLayout("%d{ISO8601} [%t] %-5p %c %x - %m%n");
            try {
                RollingFileAppender fileAppender = new RollingFileAppender((Layout)layout, this.getLogFilePath());
                fileAppender.setName("samlDebug");
                rootLogger.addAppender((Appender)fileAppender);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        } else if (samlDebug != null) {
            rootLogger.removeAppender(samlDebug);
        }
    }

    @Override
    public SAMLSettings getSettings() {
        this.loadSettings();
        return this.samlSettings;
    }

    public boolean isForceSAML() {
        this.checkSettings();
        return this.samlSettings.isForceSAML();
    }

    public boolean isDisableChangePassword() {
        this.checkSettings();
        return this.samlSettings.isDisableChangePassword();
    }

    public String getButtonTitle() {
        this.checkSettings();
        return this.samlSettings.getButtonTitle();
    }

    @Override
    public String getSpEntityId() {
        this.checkSettings();
        return StringUtils.defaultString(this.samlSettings.getSpEntityId(), this.getBaseUrl());
    }

    @Override
    public String getIdpXML() {
        this.checkSettings();
        return this.samlSettings.getIdpXml();
    }

    @Override
    public String getIdpXMLProvider() {
        this.checkSettings();
        return this.samlSettings.getIdpXmlProvider();
    }

    @Override
    public int getMaxAuthenticationAge() {
        this.checkSettings();
        return this.samlSettings.getMaxAuthenticationAge();
    }

    public String getForceSAMLValue() {
        return this.isForceSAML() ? "true" : "false";
    }

    @Override
    public boolean isSingleLogoutEnabled() {
        this.checkSettings();
        return this.samlSettings.isSingleLogout();
    }

    private String getShowLoginValue() {
        this.checkSettings();
        return this.samlSettings.isShowLogin() ? "true" : "false";
    }

    public String getShowButtonValue() {
        return this.isShowButton() ? "true" : "false";
    }

    private String getShowServiceDeskLoginValue() {
        this.checkSettings();
        return this.samlSettings.isShowServiceDeskLogin() ? "true" : "false";
    }

    public String getDisableChangePasswordValue() {
        return this.isDisableChangePassword() ? "true" : "false";
    }

    public String getConfigString() {
        return "{  \"forceSAML\":" + this.getForceSAMLValue() + " , \"restricted\":" + this.isRestricted() + " , \"license\":" + this.getLicenseString() + " , \"showLogin\":" + this.getShowLoginValue() + " , \"showButton\":" + this.getShowButtonValue() + " , \"disableChangePassword\":" + this.getDisableChangePasswordValue() + " , \"buttonTitle\":\"" + this.getButtonTitle() + "\" , \"samlEndpoint\":\"" + this.getSAMLEndPointUsingBaseUrl() + "\" " + (this.serviceDeskAvailable() ? ", \"serviceDesk\":" + this.getShowServiceDeskValue() : "") + (this.serviceDeskAvailable() ? ", \"showServiceDeskLogin\":" + this.getShowServiceDeskLoginValue() : "") + "}";
    }

    private String getShowServiceDeskValue() {
        return this.isShowServiceDeskButton() ? "true" : "false";
    }

    @Override
    public int getResponseSkew() {
        this.checkSettings();
        return this.samlSettings.getResponseSkew();
    }

    @Override
    public boolean disableInResponseToCheck() {
        this.checkSettings();
        return this.samlSettings.isDisableInResponseToCheck();
    }

    @Override
    public boolean useEmailForLookup() {
        this.checkSettings();
        return this.samlSettings.isUseEmailForLookup();
    }

    @Override
    public long getModifiedTimestamp() {
        this.checkSettings();
        return this.samlSettings.getModifiedTimestamp();
    }

    public boolean isRestricted() {
        this.checkSettings();
        String[] userGroups = this.samlSettings.getRestrictedUserGroupList();
        return this.hasValidLicense() && userGroups.length != 0;
    }

    public boolean isShowButton() {
        this.checkSettings();
        return this.samlSettings.isShowButton();
    }

    private boolean isShowServiceDeskButton() {
        this.checkSettings();
        return this.samlSettings.isServiceDesk();
    }

    @Override
    public SAMLUserMapping getSAMLUserMapping() {
        this.checkSettings();
        return this.samlSettings.createSAMLUserMapping();
    }

    private String getLicenseString() {
        return this.getLicense();
    }

    public String getSamlEndPoint(HttpServletRequest req) {
        return SAMLUtils.getDefaultBaseURL(req) + "/plugins/servlet/saml/auth";
    }

    @Override
    public String getSAMLEndPointUsingBaseUrl() {
        return this.getBaseUrl() + "/plugins/servlet/saml/auth";
    }

    public String getSPXML(HttpServletRequest request) {
        return this.getSPXML();
    }

    public String getSPXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<md:EntityDescriptor xmlns:md=\"urn:oasis:names:tc:SAML:2.0:metadata\"\n    xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"\n    entityID=\"" + this.getSpEntityId() + "\">\n    <md:SPSSODescriptor\n        protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n        <md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</md:NameIDFormat>\n        <md:AssertionConsumerService index=\"0\" isDefault=\"true\"\n            Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n            Location=\"" + this.getSAMLEndPointUsingBaseUrl() + "\"/>\n");
        String certificate = this.getSPX509Certificate();
        if (StringUtils.isNotBlank(certificate)) {
            sb.append("        <md:KeyDescriptor>\n          <ds:KeyInfo>\n            <ds:X509Data>\n              <ds:X509Certificate>\n" + this.getSPX509Certificate() + "\n              </ds:X509Certificate>\n            </ds:X509Data>\n          </ds:KeyInfo>\n        </md:KeyDescriptor>");
        }
        sb.append("  </md:SPSSODescriptor>\n</md:EntityDescriptor>");
        return sb.toString();
    }

    @Override
    public String getSPX509Certificate() {
        try {
            LOGGER.debug("Get Certificate");
            KeystoreUtils keystoreUtils = new KeystoreUtils();
            KeyStore keyStore = keystoreUtils.getKeyStore(this.getSAMLHome(), this.getSpEntityId());
            return keystoreUtils.getCertificate(keyStore);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public String getSPX509CertificateWithHeaderAndFooter() {
        return "-----BEGIN CERTIFICATE-----\n" + this.getSPX509Certificate() + "\n-----END CERTIFICATE-----";
    }

    @Override
    public final String getAlias() {
        return "/plugins/servlet/saml/config";
    }

    @Override
    public boolean isInDebugMode() {
        return LoggerFactory.getLogger("eu.toimproveit.saml").isInfoEnabled();
    }

    @Override
    public void renewCertificate(SAMLSettings settings) {
        if (settings.isRenewCertificate()) {
            settings.setRenewCertificate(false);
            new KeystoreUtils().removeKeystore(this.getSAMLHome());
        }
    }

    @Override
    public void saveSettings(SAMLSettings samlSettings) {
        samlSettings.setModifiedTimestamp(System.currentTimeMillis());
        samlSettings.setSamlEndPoint(this.getBaseUrl() + "/plugins/servlet/saml/auth");
        samlSettings.setValidString(new KeystoreUtils().getValidString(samlSettings.getSpCert()));
        this.enableDebugLog(samlSettings.isEnableDebugLog());
        String json = new Gson().toJson(samlSettings);
        this.setPluginSetting("saml2.settings", json);
        this.samlSettings = samlSettings;
    }

    @Override
    public String getVersion() {
        return "Unknown";
    }

    private void loadSettings() {
        Object objectSettings = this.getPluginSetting("saml2.settings");
        if (objectSettings != null) {
            String settings = objectSettings.toString();
            this.samlSettings = new Gson().fromJson(settings, SAMLSettings.class);
        } else {
            this.samlSettings = this.loadOldSettings();
        }
        this.samlSettings.setSpXml(this.getSPXML());
        this.samlSettings.setSpCert(this.getSPX509CertificateWithHeaderAndFooter());
        this.samlSettings.setEnableDebugLog(this.debugLogEnabled());
        this.samlSettings.setVersion(this.getVersion());
        this.samlSettings.setValidString(new KeystoreUtils().getValidString(this.samlSettings.getSpCert()));
    }

    private void checkSettings() {
        if (this.samlSettings == null) {
            this.loadSettings();
        }
    }

    private SAMLSettings loadOldSettings() {
        Gson gson;
        SAMLUserMapping userMapping;
        SAMLSettings samlSettings = new SAMLSettings(this.getBaseUrl());
        samlSettings.setForceSAML(StringUtils.defaultString((String)this.getPluginSetting(FORCE_SAML_SETTING)).equals("true"));
        samlSettings.setDisableChangePassword(StringUtils.defaultString((String)this.getPluginSetting(DISABLE_CHANGE_PASSWORD), "false").equals("true"));
        samlSettings.setActivateUser(StringUtils.defaultString((String)this.getPluginSetting(ACTIVATE_USER), "false").equals("true"));
        samlSettings.setCreateUser(StringUtils.defaultString((String)this.getPluginSetting(CREATE_USER), "false").equals("true"));
        samlSettings.setCanCreateUsergroups(StringUtils.defaultString((String)this.getPluginSetting(CAN_CREATE_USERGROUPS), "false").equals("true"));
        samlSettings.setCanUpdateUsergroups(StringUtils.defaultString((String)this.getPluginSetting(CAN_UPDATE_USERGROUPS), "false").equals("true"));
        samlSettings.setCanRemoveUsergroups(StringUtils.defaultString((String)this.getPluginSetting(CAN_REMOVE_USERGROUPS), "false").equals("true"));
        samlSettings.setServiceDesk(StringUtils.defaultString((String)this.getPluginSetting(SERVICE_DESK), "false").equals("true"));
        samlSettings.setDefaultUsergroup(StringUtils.defaultString((String)this.getPluginSetting(DEFAULT_USERGROUP), ""));
        samlSettings.setAllowedUsergroups(StringUtils.defaultString((String)this.getPluginSetting(ALLOWED_USERGROUPS), ""));
        samlSettings.setButtonTitle(StringUtils.defaultString((String)this.getPluginSetting(BUTTON_TITLE_SETTING), "Login using SAML IDP Server"));
        samlSettings.setSpEntityId(StringUtils.defaultString((String)this.getPluginSetting(SP_ENTITY_ID_SETTING), this.getBaseUrl()));
        samlSettings.setIdpXml(StringUtils.defaultString((String)this.getPluginSetting(IDP_XML)));
        samlSettings.setIdpXmlProvider(StringUtils.defaultString((String)this.getPluginSetting(IDP_XML_PROVIDER), "text"));
        samlSettings.setMaxAuthenticationAge(Integer.parseInt(StringUtils.defaultString((String)this.getPluginSetting(MAX_AUTHENTICATION_AGE), "7200")));
        samlSettings.setResponseSkew(Integer.parseInt(StringUtils.defaultString((String)this.getPluginSetting(RESPONSE_SKEW), "60")));
        samlSettings.setShowButton(StringUtils.defaultString((String)this.getPluginSetting(SHOW_BUTTON_SETTING), "true").equals("true"));
        samlSettings.setHeaderUserName(StringUtils.defaultString((String)this.getPluginSetting(HEADER_USER_NAME), ""));
        samlSettings.setHeaderTokenName(StringUtils.defaultString((String)this.getPluginSetting(HEADER_TOKEN_NAME), ""));
        samlSettings.setHeaderTokenValue(StringUtils.defaultString((String)this.getPluginSetting(HEADER_TOKEN_VALUE), ""));
        String userMappingValue = (String)this.getPluginSetting(SAML_USER_MAPPING);
        if (userMappingValue != null && (userMapping = (gson = new Gson()).fromJson(userMappingValue, SAMLUserMapping.class)) != null) {
            samlSettings.setCreateUserGroups(userMapping.getGroupsField());
            samlSettings.setCreateUserEmail(userMapping.getEmailField());
            samlSettings.setCreateUserId(userMapping.getUseridField());
            samlSettings.setCreateUserName(userMapping.getUsernameField());
        }
        this.saveSettings(samlSettings);
        return samlSettings;
    }
}

