/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.avatar.service;

import eu.toimproveit.avatar.service.AvatarService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseAvatarService
implements AvatarService {
    private Log log = LogFactory.getLog(BaseAvatarService.class);

    protected byte[] getDefaultImage() {
        String imageString = "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";
        return Base64.getDecoder().decode(imageString);
    }

    protected void readIntoBuffer(InputStream inputStream, ByteArrayOutputStream outputStream) throws IOException {
        int nRead;
        byte[] data = new byte[4096];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            outputStream.write(data, 0, nRead);
        }
        outputStream.flush();
    }

    protected boolean equalHash(String emailAddress, String emailHash) {
        return emailHash.equalsIgnoreCase(DigestUtils.md5Hex(emailAddress.getBytes()));
    }
}

