AJS.$(function () {

    var forceSAML = true;

    if (AJS.$("#loginForm").length) {
        insertSAMLLogin(AJS.$("#loginForm"));
    }

    if (AJS.$('a[href="' + AJS.contextPath() + '/profile/changePassword.action"]').length > 0 || AJS.$('form[id="changePassword"]').length > 0) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/saml/config?param=config",
            type: "GET",
            error: function () {
                console.log("Error getting SAML Config")
            },
            success: function (response) {
                var config = JSON.parse(response);
                if (config.disableChangePassword) {
                    AJS.$('a[href="' + AJS.contextPath() + '/profile/changePassword.action"]').remove();
                    AJS.$('form[id="changePassword"]').remove();
                }

            }
        });
    }

    function insertSAMLLogin(loginForm) {
        if (location.toString().indexOf("secure/admin/WebSudoAuthenticate") >= 0) {
            return;
        }
        if (loginForm.length === 1) {
            loginFormId = loginForm[0].id

            if (loginForm[0].action.indexOf("secure/admin/WebSudoAuthenticate") >= 0) {
                return;
            }

            var query = location.search.substr(1);
            query.split("&").forEach(function (part) {
                var item = part.split("=");
                if (item.length === 2 && item[0] === "samlerror") {
                    var errorKeys = {};
                    errorKeys["general"] = "General SAML configuration error";
                    errorKeys["user_not_found"] = "User was not found";
                    errorKeys["plugin_exception"] = "SAML plugin internal error";
                    errorKeys["forceSAML"] = "SAML Error during forced SAML";
                    errorKeys["licenseError"] = "Invalid SAML Plugin License";
                    errorKeys["user_not_allowed"] = "User is not allowed to use this application";
                    errorKeys["user_not_active"] = "User is not activated";
                    loginForm[0].action = loginForm[0].action + "?noSAML"
                    var message = '<div class="aui-message closeable error">' + errorKeys[item[1]] + '</div>';
                    AJS.$(message).insertBefore(loginForm);
                    forceSAML = false;
                } else if(item.length === 2 && item[0] === "samlwarn") {
                    var warnKeys = {};
                    warnKeys["restrictSAML"] = "User can only use SAML to login";
                    var message = '<div class="aui-message closeable error">' + warnKeys[item[1]] + '</div>';
                    AJS.$(message).insertBefore(loginForm);
                    forceSAML = false;
                } else if (item.length === 1) {
                    if ((item[0] === 'noSAML') || (item[0] === 'noSSO')) {
                        var message = '<div class="aui-message closeable info">Disabled SAML</div>';
                        AJS.$(message).insertBefore(loginForm);
                        forceSAML = false;
                    }
                }
            });
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/saml/config?param=config",
                type: "GET",
                error: function () {
                    var message = '<div class="aui-message closeable error">Error retrieving SAML Configuration</div>';
                    AJS.$(message).insertBefore(loginForm);

                },
                success: function (response) {
                    var config = JSON.parse(response);
                    if (config.license.licensed) {
                        showSAMLButton(config, loginForm)
                    } else {
                        var message = '<div class="aui-message closeable error">SAML PlugIn License Error: ' + config.license.licenseMessage + '</div>';
                        AJS.$(message).insertBefore(loginForm);
                        AJS.$("#samlButton")[0].hide();
                    }
                }
            });

        }
    }

    function showSAMLButton(config, loginForm) {
        redirectUrl = "";
        var showLogin = false;
        var query = location.search.substr(1);
        query.split("&").forEach(function (part) {
            var item = part.split("=");
            if (item.length === 2 && item[0] === "samlRedirectUrl") {
                redirectUrl = '?' + part;
            } else if (item.length === 2 && item[0] === "os_destination") {
                redirectUrl = '?' + part;
            } else if (item.length === 1) {
                if ((item[0] === 'noSAML') || (item[0] === 'noSSO')) {
                    config.forceSAML = false;
                    loginForm[0].action = loginForm[0].action + "?noSAML"
                } else if(item[0] === 'showLogin') {
                    showLogin = true;
                }
            }
        });
        if (query.indexOf("samlerror=") >= 0) {
            // Show the error
        } else if (config.forceSAML && query.indexOf("samlwarn=") < 0) {
            loginForm.hide();
            AJS.$('<p>Please wait: we redirect you to your company login page</p>').insertBefore(loginForm);
            window.location.href = config.samlEndpoint + redirectUrl;
        } else if (config.showButton || location.search.indexOf("samlLoginButton=true") > 0) {
            var samlElement = '<div style="margin: 30px 0; text-align: center">' +
                '<a id="samlButton" class="aui-button aui-style aui-button-primary" href="' + config.samlEndpoint +
                redirectUrl + '" style="align:center;">Use Corporate Login</a></div>';
            if (config.showLogin || showLogin) {
                samlElement += '<div style="width: 100%; text-align: center; border-bottom: 1px solid var(--ds-border); line-height: 0.1em; margin: 0 0 30px;">' +
                    '<span style="background: var(--ds-surface); padding: 0 10px; color: var(--aui-form-label-text-color)">or</span></div>';
            }
            AJS.$(samlElement).insertBefore(loginForm);
            AJS.$("#samlButton")[0].innerHTML = config.buttonTitle;
        }
        if (config.showButton && !config.showLogin && !showLogin) {
            loginForm.remove()
        }
    }
});
