/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.bamboo.utils;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.user.User;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SAMLLoginUtils {
    private static Log log = LogFactory.getLog(SAMLLoginUtils.class);

    public String getLoginUri(LoginUriProvider loginUriProvider, HttpServletRequest request) {
        try {
            URI uri = loginUriProvider.getLoginUri(new URI(request.getRequestURI()));
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (URISyntaxException e) {
            log.error("saml plugin: uri syntax error", e);
        }
        return "";
    }

    public boolean authenticateSAMLUser(HttpServletRequest request, HttpServletResponse response, String userName) {
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        try {
            if (authenticator instanceof DefaultAuthenticator) {
                Method getUserMethod = DefaultAuthenticator.class.getDeclaredMethod("getUser", String.class);
                getUserMethod.setAccessible(true);
                Object userObject = getUserMethod.invoke((Object)authenticator, userName);
                if (userObject == null) {
                    log.info("saml plugin: userObject is null");
                } else {
                    log.info("saml plugin: userObject.toString() : " + userObject.toString());
                }
                if (userObject instanceof User) {
                    Principal principal = (Principal)userObject;
                    Method authUserMethod = DefaultAuthenticator.class.getDeclaredMethod("authoriseUserAndEstablishSession", HttpServletRequest.class, HttpServletResponse.class, Principal.class);
                    authUserMethod.setAccessible(true);
                    return (Boolean)authUserMethod.invoke((Object)authenticator, request, response, principal);
                }
            }
            log.warn("saml plugin: User Not Found");
        }
        catch (Exception e) {
            log.error("saml plugin: error During authenticateUserAndLogin", e);
            throw new RuntimeException(e);
        }
        return false;
    }
}

