/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.bamboo.user;

import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.Credential;
import eu.toimproveit.saml.bamboo.user.GroupImpl;
import eu.toimproveit.saml.bamboo.user.UserImpl;
import eu.toimproveit.user.IGroup;
import eu.toimproveit.user.IUser;
import eu.toimproveit.user.IUserDirectory;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BambooUserDirectory
implements IUserDirectory {
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final BambooUserManager bambooUserManager;
    private final Log log = LogFactory.getLog(BambooUserDirectory.class);

    public BambooUserDirectory(UserManager userManager, GroupManager groupManager, BambooUserManager bambooUserManager) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.bambooUserManager = bambooUserManager;
    }

    @Override
    public IUser getUserByName(String userName) {
        try {
            User user = this.userManager.getUser(userName);
            if (user != null) {
                return new UserImpl(user);
            }
        }
        catch (EntityException e) {
            this.log.error("SAML: Error getting user", e);
        }
        return null;
    }

    @Override
    public IUser getUserByEmail(String email) {
        SearchResult searchResult = this.bambooUserManager.getUsersByEmail(email);
        Pager pager = searchResult.pager();
        if (!pager.isEmpty()) {
            Iterator iterator = pager.iterator();
            try {
                User user = this.userManager.getUser(((User)iterator.next()).getName());
                if (user != null) {
                    return new UserImpl(user);
                }
            }
            catch (EntityException e) {
                e.printStackTrace();
            }
            if (iterator.hasNext()) {
                this.log.info("More than 1 user found with email " + email + " taking one of them");
            }
        }
        return null;
    }

    @Override
    public IUser createUser(String userName, String displayName, String email, String password) {
        IUser user = this.getUserByName(userName);
        if (user == null) {
            try {
                User bambooUser = this.userManager.createUser((User)new DefaultUser(userName, displayName, email), Credential.unencrypted((String)password));
                return new UserImpl(bambooUser);
            }
            catch (Exception e) {
                return null;
            }
        }
        return user;
    }

    @Override
    public IGroup[] getUserGroups(IUser iUser) {
        User user = ((UserImpl)iUser).getUser();
        ArrayList<GroupImpl> groupsForUser = new ArrayList<GroupImpl>();
        try {
            Pager groupsPager = this.groupManager.getGroups(user);
            do {
                for (Group group : groupsPager.getCurrentPage()) {
                    groupsForUser.add(new GroupImpl(group));
                }
                groupsPager.nextPage();
            } while (!groupsPager.onLastPage());
        }
        catch (EntityException e) {
            this.log.error("Error getting groups", e);
        }
        return groupsForUser.toArray(new IGroup[0]);
    }

    @Override
    public IGroup getGroupByName(String groupName) {
        GroupImpl result = null;
        try {
            Group group = this.groupManager.getGroup(groupName);
            if (group != null) {
                result = new GroupImpl(group);
            }
        }
        catch (EntityException e) {
            this.log.error("Error getting group " + groupName, e);
        }
        return result;
    }

    @Override
    public boolean removeUserFromGroup(IUser iUser, IGroup iGroup) {
        User user = ((UserImpl)iUser).getUser();
        Group group = ((GroupImpl)iGroup).getGroup();
        try {
            this.groupManager.removeMembership(group, user);
            return true;
        }
        catch (EntityException e) {
            this.log.error("Error removing user from group", e);
            return false;
        }
    }

    @Override
    public boolean addUserToGroup(IUser iUser, String groupName) {
        User user = ((UserImpl)iUser).getUser();
        try {
            Group group = this.groupManager.getGroup(groupName);
            if (group != null) {
                this.groupManager.addMembership(group, user);
                return true;
            }
        }
        catch (EntityException e) {
            this.log.error("Error adding user to group", e);
        }
        return false;
    }

    @Override
    public boolean createGroupAndAddUser(IUser iUser, String groupName) {
        User user = ((UserImpl)iUser).getUser();
        try {
            Group group = this.groupManager.createGroup(groupName);
            if (group != null) {
                this.groupManager.addMembership(group, user);
            }
            return group != null;
        }
        catch (EntityException e) {
            this.log.error("Error creating group", e);
            return false;
        }
    }
}

