/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.bamboo.config;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.setup.BambooApplicationConfig;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import eu.toimproveit.saml.AbstractXMLSAMLConfig;
import java.io.File;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Named
public class SAML4BambooConfig
extends AbstractXMLSAMLConfig {
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @Override
    public Object getPluginSetting(String key) {
        return this.pluginSettings.get(key);
    }

    @Override
    public void setPluginSetting(String key, String value) {
        this.pluginSettings.put(key, (Object)value);
    }

    @Override
    public boolean activateUserAvailable() {
        return false;
    }

    @Override
    public String getLogoutUrl(HttpServletRequest httpServletRequest) {
        return String.format("%s/userLogout.action", this.getBaseUrl());
    }

    public AdministrationConfigurationAccessor getAdministrationConfigurationAccessor() {
        return this.administrationConfigurationAccessor;
    }

    public void loadSettings() {
        if (this.administrationConfigurationAccessor != null && this.pluginSettings != null) {
            super.getSettings();
        }
    }

    @Inject
    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.loadSettings();
    }

    @Inject
    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.loadSettings();
    }

    @Inject
    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public String getVersion() {
        return String.format("Bamboo: %s, SAMLPlugin: %s", BuildUtils.getCurrentVersion(), this.getPluginVersion());
    }

    private String getPluginVersion() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("atlassian-plugin.xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList nodes = doc.getDocumentElement().getElementsByTagName("plugin-info").item(0).getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!nodes.item(i).getNodeName().equalsIgnoreCase("version")) continue;
                return nodes.item(i).getTextContent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown";
    }

    @Override
    public String getBaseUrl() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
    }

    @Override
    public String getLicense() {
        boolean licensed = false;
        String licenseMessage = "Unknown";
        Option license = this.pluginLicenseManager.getLicense();
        if (license.isDefined()) {
            if (((PluginLicense)license.get()).getError().isDefined()) {
                licensed = false;
                if (((LicenseError)((PluginLicense)license.get()).getError().get()).equals((Object)LicenseError.EXPIRED)) {
                    licenseMessage = "Expired";
                } else if (((LicenseError)((PluginLicense)license.get()).getError().get()).equals((Object)LicenseError.TYPE_MISMATCH)) {
                    licenseMessage = "Type Mismatch";
                } else if (((LicenseError)((PluginLicense)license.get()).getError().get()).equals((Object)LicenseError.USER_MISMATCH)) {
                    licenseMessage = "User Mismatch";
                } else if (((LicenseError)((PluginLicense)license.get()).getError().get()).equals((Object)LicenseError.VERSION_MISMATCH)) {
                    licenseMessage = "Version Mismatch";
                }
            } else {
                licenseMessage = "Valid";
                licensed = true;
            }
        } else {
            licensed = false;
            licenseMessage = "No License";
        }
        return "{  \"licensed\":" + licensed + " , \"licenseMessage\":\"" + licenseMessage + "\"}";
    }

    @Override
    public boolean hasValidLicense() {
        boolean licensed = false;
        if (this.pluginLicenseManager != null) {
            Option license = this.pluginLicenseManager.getLicense();
            licensed = license.isDefined() ? !((PluginLicense)license.get()).getError().isDefined() : false;
        }
        return licensed;
    }

    @Override
    public File getSAMLHome() {
        BambooApplicationConfig bambooApplicationConfig = new BambooApplicationConfig();
        File samlHome = new File(bambooApplicationConfig.getApplicationHome(), "saml");
        return samlHome;
    }

    @Override
    public String getSamlEndPoint(HttpServletRequest req) {
        return this.getSAMLEndPointUsingBaseUrl();
    }
}

