/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.SAMLVelocityUtils;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import java.util.Scanner;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class SAMLTemplateRenderer {
    public void render(Writer writer, String templateName, SAMLConfig config, List<String> headers) {
        VelocityContext context = new VelocityContext();
        context.put("samlUtils", new SAMLVelocityUtils());
        context.put("settings", config.getSettings());
        context.put("validLicense", config.hasValidLicense());
        context.put("headers", headers);
        context.put("showTitle", config.showTitle());
        context.put("showTitle", config.showTitle());
        context.put("showServiceDesk", config.serviceDeskAvailable());
        context.put("showChangePassword", config.disableChangePasswordAvailable());
        context.put("avatarServletAvailable", config.avatarServletAvailable());
        InputStream resource = SAMLTemplateRenderer.class.getResourceAsStream("/" + templateName);
        this.render(writer, resource, context);
    }

    public void render(Writer writer, InputStream resource, VelocityContext context) {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.init();
        String template = new Scanner(resource, "UTF-8").useDelimiter("\\A").next();
        velocityEngine.evaluate((Context)context, writer, "", template);
    }
}

