/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import com.onelogin.saml2.Auth;
import com.onelogin.saml2.logout.LogoutRequestParams;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import com.onelogin.saml2.util.Util;
import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.SAMLLogoutHandler;
import eu.toimproveit.saml.SAMLUser;
import eu.toimproveit.saml.model.SAMLUserMapping;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAMLContext {
    private Log log = LogFactory.getLog(SAMLContext.class);
    private final boolean isLogoutEnabled;
    SAMLUserMapping samlUserMapping;
    private int responseSkew;
    private int maxAuthenticationAge;
    private Saml2Settings settings;

    public SAMLContext(SAMLConfig configuration) throws IOException {
        this.maxAuthenticationAge = configuration.getMaxAuthenticationAge();
        if (this.maxAuthenticationAge <= 0) {
            this.maxAuthenticationAge = Integer.MAX_VALUE;
        }
        this.responseSkew = configuration.getResponseSkew();
        if (this.responseSkew <= 0) {
            this.responseSkew = Integer.MAX_VALUE;
        }
        this.samlUserMapping = configuration.getSAMLUserMapping();
        this.isLogoutEnabled = configuration.isSingleLogoutEnabled();
        boolean rejectInResponseTo = !configuration.disableInResponseToCheck();
        HashMap<String, Object> samlData = new HashMap<String, Object>();
        samlData.put("onelogin.saml2.sp.nameidformat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        samlData.put("onelogin.saml2.sp.entityid", configuration.getSpEntityId());
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.url", new URL(configuration.getSAMLEndPointUsingBaseUrl()));
        samlData.put("onelogin.saml2.security.allow_duplicated_attribute_name", true);
        samlData.put("onelogin.saml2.security.reject_unsolicited_responses_with_inresponseto", rejectInResponseTo);
        SettingsBuilder builder = new SettingsBuilder();
        this.settings = builder.fromValues(samlData).build();
        try {
            String idpXML = configuration.getIdpXML();
            if (idpXML != null && idpXML.length() > 0) {
                Document xmlDocument;
                String idpXMLProvider = configuration.getIdpXMLProvider().toLowerCase();
                if (Objects.equals(idpXMLProvider, "url")) {
                    URL xmlURL = new URL(idpXML);
                    xmlDocument = Util.parseXML(new InputSource(xmlURL.openStream()));
                } else if (Objects.equals(idpXMLProvider, "file")) {
                    try (InputStream inputStream = Files.newInputStream(Paths.get(idpXML, new String[0]), new OpenOption[0]);){
                        xmlDocument = Util.parseXML(new InputSource(inputStream));
                    }
                } else {
                    xmlDocument = Util.loadXML(idpXML);
                }
                Map<String, Object> idPInfo = IdPMetadataParser.parseXML(xmlDocument, null, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", null, null);
                IdPMetadataParser.injectIntoSettings(this.settings, idPInfo);
            } else {
                this.log.warn("IDPXML not set.");
            }
        }
        catch (ParserConfigurationException | XPathException | SAXException e) {
            this.log.error("Error reading IdPXML", e);
            throw new RuntimeException(e);
        }
    }

    public SAMLUser getUser(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, Exception {
        Auth auth = new Auth(this.settings, req, resp);
        auth.processResponse();
        if (!auth.isAuthenticated()) {
            List<String> errors = auth.getErrors();
            if (!errors.isEmpty()) {
                String errorReason;
                this.log.error(StringUtils.join(errors, ", "));
                if (auth.isDebugActive().booleanValue() && (errorReason = auth.getLastErrorReason()) != null && !errorReason.isEmpty()) {
                    this.log.error(auth.getLastErrorReason());
                }
            }
            return null;
        }
        Map<String, List<String>> attributes = auth.getAttributes();
        req.getSession().setAttribute("SAMLCredential", (Object)auth.getNameId());
        String nameId = auth.getNameId();
        String nameIdFormat = auth.getNameIdFormat();
        String sessionIndex = auth.getSessionIndex();
        String nameidNameQualifier = auth.getNameIdNameQualifier();
        String nameidSPNameQualifier = auth.getNameIdSPNameQualifier();
        HttpSession session = req.getSession();
        session.setAttribute("attributes", attributes);
        session.setAttribute("nameId", (Object)nameId);
        session.setAttribute("nameIdFormat", (Object)nameIdFormat);
        session.setAttribute("sessionIndex", (Object)sessionIndex);
        session.setAttribute("nameidNameQualifier", (Object)nameidNameQualifier);
        session.setAttribute("nameidSPNameQualifier", (Object)nameidSPNameQualifier);
        SAMLUser user = new SAMLUser();
        user.setSamlUserMapping(this.samlUserMapping);
        user.setNameId(auth.getNameId());
        Set<String> keys = attributes.keySet();
        for (String name : keys) {
            user.addAttribute(name, attributes.get(name).toArray(new String[0]));
        }
        return user;
    }

    public void sendAuthenticationRequest(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Auth auth = new Auth(this.settings, req, resp);
        auth.login();
    }

    public void sendLogoutRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        if (session != null && session.getAttribute("SAMLCredential") != null) {
            Auth auth = new Auth(this.settings, request, response);
            String nameId = null;
            if (session.getAttribute("nameId") != null) {
                nameId = session.getAttribute("nameId").toString();
            }
            String nameIdFormat = null;
            if (session.getAttribute("nameIdFormat") != null) {
                nameIdFormat = session.getAttribute("nameIdFormat").toString();
            }
            String nameidNameQualifier = null;
            if (session.getAttribute("nameidNameQualifier") != null) {
                nameidNameQualifier = session.getAttribute("nameidNameQualifier").toString();
            }
            String nameidSPNameQualifier = null;
            if (session.getAttribute("nameidSPNameQualifier") != null) {
                nameidSPNameQualifier = session.getAttribute("nameidSPNameQualifier").toString();
            }
            String sessionIndex = null;
            if (session.getAttribute("sessionIndex") != null) {
                sessionIndex = session.getAttribute("sessionIndex").toString();
            }
            auth.logout(null, new LogoutRequestParams(sessionIndex, nameId, nameIdFormat, nameidNameQualifier, nameidSPNameQualifier));
        }
    }

    public boolean processLogout(HttpServletRequest request, HttpServletResponse response, SAMLLogoutHandler logoutHandler) throws Exception {
        this.log.info("Process Logout");
        HttpSession session = request.getSession();
        if (session != null) {
            session.removeAttribute("SAMLCredential");
        }
        if (logoutHandler != null) {
            logoutHandler.logout(request, response);
        }
        return true;
    }

    public String getSPXML(HttpServletRequest request, HttpServletResponse response) {
        try {
            Auth auth = new Auth(this.settings, request, response);
            return auth.getSettings().getSPMetadata();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<Error><!CDATA[[" + e.getMessage() + "]]></Error>";
        }
    }

    public String getUserId(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }
}

