/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import java.io.ByteArrayOutputStream;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debugger {
    private static final Logger LOGGER = LoggerFactory.getLogger(Debugger.class);

    public static void debugRequest(HttpServletRequest httpServletRequest) {
        try {
            Debugger.printRequest(httpServletRequest);
        }
        catch (Throwable e) {
            LOGGER.error("Could not dump the servlet", e);
        }
    }

    private static void printRequest(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return;
        }
        LOGGER.info("----------------------------------------");
        LOGGER.info("HttpServletRequest");
        LOGGER.info("\tRequestURL : {}", (Object)httpServletRequest.getRequestURL());
        LOGGER.info("\tRequestURI : {}", (Object)httpServletRequest.getRequestURI());
        LOGGER.info("\tScheme : {}", (Object)httpServletRequest.getScheme());
        LOGGER.info("\tAuthType : {}", (Object)httpServletRequest.getAuthType());
        LOGGER.info("\tEncoding : {}", (Object)httpServletRequest.getCharacterEncoding());
        LOGGER.info("\tContentLength : {}", (Object)httpServletRequest.getContentLength());
        LOGGER.info("\tContentType : {}", (Object)httpServletRequest.getContentType());
        LOGGER.info("\tContextPath : {}", (Object)httpServletRequest.getContextPath());
        LOGGER.info("\tMethod : {}", (Object)httpServletRequest.getMethod());
        LOGGER.info("\tPathInfo : {}", (Object)httpServletRequest.getPathInfo());
        LOGGER.info("\tProtocol : {}", (Object)httpServletRequest.getProtocol());
        LOGGER.info("\tQuery : {}", (Object)httpServletRequest.getQueryString());
        LOGGER.info("\tRemoteAddr : {}", (Object)httpServletRequest.getRemoteAddr());
        LOGGER.info("\tRemoteHost : {}", (Object)httpServletRequest.getRemoteHost());
        LOGGER.info("\tRemotePort : {}", (Object)httpServletRequest.getRemotePort());
        LOGGER.info("\tRemoteUser : {}", (Object)httpServletRequest.getRemoteUser());
        LOGGER.info("\tRequestedSessionId : {}", (Object)httpServletRequest.getRequestedSessionId());
        LOGGER.info("\tServerName : {}", (Object)httpServletRequest.getServerName());
        LOGGER.info("\tServerPort : {}", (Object)httpServletRequest.getServerPort());
        LOGGER.info("\tServletPath : {}", (Object)httpServletRequest.getServletPath());
        LOGGER.info("");
        LOGGER.info("\tCookies");
        int i = 0;
        for (Cookie cookie : httpServletRequest.getCookies()) {
            LOGGER.info("\tCookie[{}].name={}", (Object)i, (Object)cookie.getName());
            LOGGER.info("\tCookie[{}].comment={}", (Object)i, (Object)cookie.getComment());
            LOGGER.info("\tCookie[{}].domain={}", (Object)i, (Object)cookie.getDomain());
            LOGGER.info("\tCookie[{}].maxAge={}", (Object)i, (Object)cookie.getMaxAge());
            LOGGER.info("\tCookie[{}].path={}", (Object)i, (Object)cookie.getPath());
            LOGGER.info("\tCookie[{}].secured={}", (Object)i, (Object)cookie.getSecure());
            LOGGER.info("\tCookie[{}].value={}", (Object)i, (Object)cookie.getValue());
            LOGGER.info("\tCookie[{}].version={}", (Object)i, (Object)cookie.getVersion());
            ++i;
        }
        LOGGER.info("");
        LOGGER.info("\tHeaders");
        int j = 0;
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String header = httpServletRequest.getHeader(headerName);
            LOGGER.info("\tHeader[{}].name={}", (Object)j, (Object)headerName);
            LOGGER.info("\tHeader[{}].value={}", (Object)j, (Object)header);
            ++j;
        }
        LOGGER.info("\tLocalAddr : {}", (Object)httpServletRequest.getLocalAddr());
        LOGGER.info("\tLocale : {}", (Object)httpServletRequest.getLocale());
        LOGGER.info("\tLocalPort : {}", (Object)httpServletRequest.getLocalPort());
        LOGGER.info("");
        LOGGER.info("\tParameters");
        int k = 0;
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            String paramValue = httpServletRequest.getParameter(paramName);
            LOGGER.info("\tParam[{}].name={}", (Object)k, (Object)paramName);
            LOGGER.info("\tParam[{}].value={}", (Object)k, (Object)paramValue);
            ++k;
        }
        Debugger.printSession(httpServletRequest.getSession());
        Debugger.printUser(httpServletRequest.getUserPrincipal());
        try {
            int numRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ServletInputStream is = httpServletRequest.getInputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, numRead);
            }
            LOGGER.info("Request Body : {}", (Object)new String(os.toByteArray(), httpServletRequest.getCharacterEncoding()));
        }
        catch (Exception e) {
            LOGGER.debug("Exception e", e);
        }
        LOGGER.info("----------------------------------------");
    }

    private static void printSession(HttpSession session) {
        LOGGER.info("-");
        if (session == null) {
            LOGGER.error("No session");
            return;
        }
        LOGGER.info("\tSession Attributes");
        LOGGER.info("\tSession.id:  {}", (Object)session.getId());
        LOGGER.info("\tSession.creationTime:  {}", (Object)session.getCreationTime());
        LOGGER.info("\tSession.lastAccessTime:  {}", (Object)session.getLastAccessedTime());
        LOGGER.info("\tSession.maxInactiveInterval:  {}", (Object)session.getMaxInactiveInterval());
        int k = 0;
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String paramName = (String)attributeNames.nextElement();
            Object paramValue = session.getAttribute(paramName);
            LOGGER.info("\tSession Attribute[{}].name={}", (Object)k, (Object)paramName);
            if (paramValue.getClass() != null) {
                LOGGER.info("\tSession Attribute[{}].class={}", (Object)k, (Object)paramValue.getClass());
            }
            LOGGER.info("\tSession Attribute[{}].value={}", (Object)k, paramValue);
            ++k;
        }
    }

    private static void printUser(Principal userPrincipal) {
        LOGGER.info("-");
        if (userPrincipal == null) {
            LOGGER.info("User Authentication : none");
        } else {
            LOGGER.info("User Authentication.name :  {}", (Object)userPrincipal.getName());
            LOGGER.info("User Authentication.class :  {}", (Object)userPrincipal.getClass());
            LOGGER.info("User Authentication.value :  {}", (Object)userPrincipal);
        }
    }
}

