/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.model;

import eu.toimproveit.saml.SAMLVelocityUtils;
import eu.toimproveit.saml.model.SAMLUserMapping;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SAMLSettings {
    private static final Log log = LogFactory.getLog("SAMLSettings");
    boolean showLogin = true;
    boolean showButton = true;
    boolean serviceDesk;
    boolean showServiceDeskLogin = true;
    boolean forceSAML;
    boolean activateUser;
    boolean createUser;
    boolean canCreateUsergroups;
    boolean canUpdateUsergroups;
    boolean canRemoveUsergroups;
    boolean disableChangePassword;
    boolean enableDebugLog;
    boolean disableInResponseToCheck = true;
    boolean useEmailForLookup;
    boolean singleLogout = false;
    boolean renewCertificate = false;
    String buttonTitle = "Login using SAML IDP Server";
    String createUserId = "NameId";
    String createUserName = "";
    String createUserEmail = "";
    String createUserGroups = "";
    String syncProfilePicture = "";
    String defaultUsergroup;
    String idpXmlProvider = "url";
    String idpXml = "";
    String samlEndPoint;
    String spEntityId;
    String spXml = "";
    String spCert = "";
    int maxAuthenticationAge = 7200;
    int responseSkew = 60;
    String allowedUsergroups;
    String restrictedUsergroups;
    String headerUserName;
    String headerTokenName;
    String headerTokenValue;
    boolean enableAvatarServlet = false;
    String tokenAvatarServlet;
    String version = "Unknown";
    String validString;
    private long modifiedTimestamp = 0L;

    public boolean isShowLogin() {
        return this.showLogin;
    }

    public void setShowLogin(boolean showLogin) {
        this.showLogin = showLogin;
    }

    public boolean isShowButton() {
        return this.showButton;
    }

    public void setShowButton(boolean showButton) {
        this.showButton = showButton;
    }

    public boolean isServiceDesk() {
        return this.serviceDesk;
    }

    public void setServiceDesk(boolean serviceDesk) {
        this.serviceDesk = serviceDesk;
    }

    public boolean isShowServiceDeskLogin() {
        return this.showServiceDeskLogin;
    }

    public void setShowServiceDeskLogin(boolean showServiceDeskLogin) {
        this.showServiceDeskLogin = showServiceDeskLogin;
    }

    public boolean isForceSAML() {
        return this.forceSAML;
    }

    public void setForceSAML(boolean forceSAML) {
        this.forceSAML = forceSAML;
    }

    public boolean isActivateUser() {
        return this.activateUser;
    }

    public void setActivateUser(boolean activateUser) {
        this.activateUser = activateUser;
    }

    public boolean isCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(boolean createUser) {
        this.createUser = createUser;
    }

    public boolean isCanCreateUsergroups() {
        return this.canCreateUsergroups;
    }

    public void setCanCreateUsergroups(boolean canCreateUsergroups) {
        this.canCreateUsergroups = canCreateUsergroups;
    }

    public boolean isCanUpdateUsergroups() {
        return this.canUpdateUsergroups;
    }

    public void setCanUpdateUsergroups(boolean canUpdateUsergroups) {
        this.canUpdateUsergroups = canUpdateUsergroups;
    }

    public boolean isCanRemoveUsergroups() {
        return this.canRemoveUsergroups;
    }

    public void setCanRemoveUsergroups(boolean canRemoveUsergroups) {
        this.canRemoveUsergroups = canRemoveUsergroups;
    }

    public boolean isDisableChangePassword() {
        return this.disableChangePassword;
    }

    public void setDisableChangePassword(boolean disableChangePassword) {
        this.disableChangePassword = disableChangePassword;
    }

    public String getButtonTitle() {
        return this.buttonTitle;
    }

    public void setButtonTitle(String buttonTitle) {
        this.buttonTitle = buttonTitle;
    }

    public String getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return this.createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getCreateUserEmail() {
        return this.createUserEmail;
    }

    public void setCreateUserEmail(String createUserEmail) {
        this.createUserEmail = createUserEmail;
    }

    public String getSyncProfilePicture() {
        return this.syncProfilePicture;
    }

    public void setSyncProfilePicture(String syncProfilePicture) {
        this.syncProfilePicture = syncProfilePicture;
    }

    public String getIdpXmlProvider() {
        return this.idpXmlProvider;
    }

    public void setIdpXmlProvider(String idpXmlProvider) {
        this.idpXmlProvider = idpXmlProvider;
    }

    public String getIdpXml() {
        return this.idpXml;
    }

    public void setIdpXml(String idpXml) {
        this.idpXml = idpXml;
    }

    public String getCreateUserGroups() {
        return this.createUserGroups;
    }

    public void setCreateUserGroups(String createUserGroups) {
        this.createUserGroups = createUserGroups;
    }

    public String getDefaultUsergroup() {
        return this.defaultUsergroup;
    }

    public void setDefaultUsergroup(String defaultUsergroup) {
        this.defaultUsergroup = defaultUsergroup;
    }

    public String getSamlEndPoint() {
        return this.samlEndPoint;
    }

    public void setSamlEndPoint(String samlEndPoint) {
        this.samlEndPoint = samlEndPoint;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public int getMaxAuthenticationAge() {
        return this.maxAuthenticationAge;
    }

    public void setMaxAuthenticationAge(int maxAuthenticationAge) {
        this.maxAuthenticationAge = maxAuthenticationAge;
    }

    public int getResponseSkew() {
        return this.responseSkew;
    }

    public void setResponseSkew(int responseSkew) {
        this.responseSkew = responseSkew;
    }

    public String getAllowedUsergroups() {
        return this.allowedUsergroups;
    }

    public void setAllowedUsergroups(String allowedUsergroups) {
        this.allowedUsergroups = allowedUsergroups;
    }

    public String getHeaderUserName() {
        return this.headerUserName;
    }

    public void setHeaderUserName(String headerUserName) {
        this.headerUserName = headerUserName;
    }

    public String getHeaderTokenName() {
        return this.headerTokenName;
    }

    public void setHeaderTokenName(String headerTokenName) {
        this.headerTokenName = headerTokenName;
    }

    public String getHeaderTokenValue() {
        return this.headerTokenValue;
    }

    public void setHeaderTokenValue(String headerTokenValue) {
        this.headerTokenValue = headerTokenValue;
    }

    public boolean isEnableAvatarServlet() {
        return this.enableAvatarServlet;
    }

    public void setEnableAvatarServlet(boolean enableAvatarServlet) {
        this.enableAvatarServlet = enableAvatarServlet;
    }

    public String getTokenAvatarServlet() {
        return this.tokenAvatarServlet;
    }

    public void setTokenAvatarServlet(String tokenAvatarServlet) {
        this.tokenAvatarServlet = tokenAvatarServlet;
    }

    public long getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public void setModifiedTimestamp(long modifiedTimestamp) {
        this.modifiedTimestamp = modifiedTimestamp;
    }

    public String getSpXml() {
        return this.spXml;
    }

    public void setSpXml(String spXml) {
        this.spXml = spXml;
    }

    public String getSpCert() {
        return this.spCert;
    }

    public void setSpCert(String spCert) {
        this.spCert = spCert;
    }

    public String getRestrictedUsergroups() {
        return this.restrictedUsergroups;
    }

    public void setRestrictedUsergroups(String restrictedUsergroups) {
        this.restrictedUsergroups = restrictedUsergroups;
    }

    public boolean isEnableDebugLog() {
        return this.enableDebugLog;
    }

    public void setEnableDebugLog(boolean enableDebugLog) {
        this.enableDebugLog = enableDebugLog;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isDisableInResponseToCheck() {
        return this.disableInResponseToCheck;
    }

    public void setDisableInResponseToCheck(boolean disableInResponseToCheck) {
        this.disableInResponseToCheck = disableInResponseToCheck;
    }

    public boolean isSingleLogout() {
        return this.singleLogout;
    }

    public void setSingleLogout(boolean singleLogout) {
        this.singleLogout = singleLogout;
    }

    public boolean isRenewCertificate() {
        return this.renewCertificate;
    }

    public void setRenewCertificate(boolean renewCertificate) {
        this.renewCertificate = renewCertificate;
    }

    public String getValidString() {
        return this.validString;
    }

    public void setValidString(String validString) {
        this.validString = validString;
    }

    public SAMLSettings() {
    }

    public SAMLSettings(String baseUrl) {
        this.setSamlEndPoint(baseUrl + "/plugins/servlet/saml/auth");
        this.setSpEntityId(baseUrl);
    }

    public SAMLUserMapping createSAMLUserMapping() {
        SAMLUserMapping samlUserMapping = new SAMLUserMapping();
        samlUserMapping.setUseridField(this.createUserId);
        samlUserMapping.setUsernameField(this.createUserName);
        samlUserMapping.setEmailField(this.createUserEmail);
        samlUserMapping.setGroupsField(this.createUserGroups);
        samlUserMapping.setAvatarField(this.syncProfilePicture);
        return samlUserMapping;
    }

    public String[] getRestrictedUserGroupList() {
        String[] userGroups = new String[]{};
        if (this.restrictedUsergroups != null && this.restrictedUsergroups.length() > 0) {
            userGroups = this.restrictedUsergroups.split(",");
            userGroups = (String[])Arrays.stream(userGroups).map(String::trim).toArray(String[]::new);
        }
        return userGroups;
    }

    public boolean isUseEmailForLookup() {
        return this.useEmailForLookup;
    }

    public void setUseEmailForLookup(boolean useEmailForLookup) {
        this.useEmailForLookup = useEmailForLookup;
    }

    public int validate(SAMLSettings currentSettings, List<String> messages) {
        SAMLVelocityUtils velocityUtils = new SAMLVelocityUtils();
        if (!this.validate(this.getSpEntityId(), velocityUtils.getText("saml2Plugin.admin.spEntityIdEmpty"), messages)) {
            this.setSpEntityId(currentSettings.getSpEntityId());
        }
        if (!this.validateXml(this.getIdpXml(), velocityUtils, messages)) {
            this.setIdpXmlProvider(currentSettings.getIdpXmlProvider());
            this.setIdpXml(currentSettings.getIdpXml());
        }
        if (!this.validate(this.getButtonTitle(), velocityUtils.getText("saml2Plugin.admin.buttonTitleEmpty"), messages)) {
            this.setButtonTitle(currentSettings.getButtonTitle());
        }
        if (!this.isShowLogin() && !this.isShowButton() || !this.isShowServiceDeskLogin() && !this.isServiceDesk()) {
            messages.add(velocityUtils.getText("saml2plugin.admin.atLeastOneLoginRequired"));
        }
        if (messages.size() > 0) {
            return 1;
        }
        messages.add(velocityUtils.getText("saml2plugin.admin.message.saved"));
        return 0;
    }

    private boolean validate(String value, String message, List<String> messages) {
        if (StringUtils.isBlank(value)) {
            this.addMessage(messages, message);
            return false;
        }
        return true;
    }

    private boolean validateXml(String value, SAMLVelocityUtils velocityUtils, List<String> messages) {
        if (!this.validate(this.getIdpXml(), velocityUtils.getText("saml2Plugin.admin.idpXmlEmpty"), messages)) {
            return false;
        }
        if (this.idpXmlProvider.equalsIgnoreCase("text")) {
            return this.checkXml(new StringReader(value), velocityUtils, messages);
        }
        if (this.idpXmlProvider.equalsIgnoreCase("url")) {
            try {
                URL url = new URL(value);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                return this.checkXml(new InputStreamReader(huc.getInputStream()), velocityUtils, messages);
            }
            catch (Exception ex) {
                this.addExceptionMessage(ex, messages, velocityUtils);
                return false;
            }
        }
        if (this.idpXmlProvider.equalsIgnoreCase("file")) {
            try {
                return this.checkXml(new FileReader(value), velocityUtils, messages);
            }
            catch (FileNotFoundException e) {
                this.addExceptionMessage(e, messages, velocityUtils);
                return false;
            }
        }
        return true;
    }

    private void addMessage(List<String> messages, String message) {
        if (messages != null) {
            messages.add(message);
        }
    }

    private boolean checkXml(Reader reader, SAMLVelocityUtils velocityUtils, List<String> messages) {
        return true;
    }

    private String readerToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            int offset = 0;
            if (arr[0] == '\ufeff') {
                offset = 1;
            }
            buffer.append(arr, offset, numCharsRead - offset);
        }
        reader.close();
        return buffer.toString();
    }

    private void addExceptionMessage(Exception exception, List<String> messages, SAMLVelocityUtils velocityUtils) {
        String message = velocityUtils.getText("saml2Plugin.admin.idpXmlInvalid");
        this.addMessage(messages, String.format("%s (%s)", message, StringEscapeUtils.escapeEcmaScript(exception.getMessage())));
    }
}

