/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLCookieUtils {
    private String cookieName;
    private String defaultRedirect;
    private String errorRedirect;
    private String redirectParameter;
    private String path;

    public SAMLCookieUtils(String domain, String defaultRedirect, String redirectParameter, String errorRedirect, String path) {
        this.cookieName = "2improveit.saml.referer." + domain;
        this.defaultRedirect = defaultRedirect;
        this.redirectParameter = redirectParameter;
        this.errorRedirect = errorRedirect;
        this.path = path;
    }

    public SAMLCookieUtils(String cookieName, String defaultRedirect, String errorRedirect, String redirectParameter) {
        this(cookieName, defaultRedirect, errorRedirect, redirectParameter, null);
    }

    public void setRedirectCookie(HttpServletRequest request, HttpServletResponse response) {
        String redirectUrl = request.getParameter(this.redirectParameter);
        if (redirectUrl == null) {
            redirectUrl = request.getParameter("samlRedirectUrl");
        }
        if (redirectUrl != null) {
            Cookie cookie = null;
            try {
                cookie = new Cookie(this.cookieName, URLEncoder.encode(redirectUrl, "UTF-8"));
                if (this.path != null) {
                    cookie.setPath(this.path);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.addCookie(cookie);
        }
    }

    public void sendRedirectUsingCookie(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.cookieName.equals(cookie.getName())) continue;
                String redirectUrl = URLDecoder.decode(cookie.getValue(), "UTF-8");
                cookie.setMaxAge(0);
                response.addCookie(cookie);
                if (redirectUrl.startsWith("/")) {
                    redirectUrl = request.getContextPath() + redirectUrl;
                }
                response.sendRedirect(redirectUrl);
                return;
            }
        }
        response.sendRedirect(request.getContextPath() + this.defaultRedirect);
    }

    public String getErrorRedirect() {
        return this.errorRedirect;
    }
}

