/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jexl3.internal.introspection.MethodKey;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.apache.commons.logging.Log;

final class ClassMap {
    private static final Method CACHE_MISS = ClassMap.cacheMiss();
    private final ConcurrentMap<MethodKey, Method> byKey = new ConcurrentHashMap<MethodKey, Method>();
    private final Map<String, Method[]> byName = new HashMap<String, Method[]>();
    private final Map<String, Field> fieldCache;

    public static Method cacheMiss() {
        try {
            return ClassMap.class.getMethod("cacheMiss", new Class[0]);
        }
        catch (Exception xio) {
            return null;
        }
    }

    ClassMap(Class<?> aClass, Log log) {
        ClassMap.create(this, aClass, log);
        Field[] fields = aClass.getFields();
        if (fields.length > 0) {
            HashMap<String, Field> cache = new HashMap<String, Field>();
            for (Field field : fields) {
                if (!Modifier.isPublic(field.getModifiers()) || !Permissions.allow(field)) continue;
                cache.put(field.getName(), field);
            }
            this.fieldCache = cache;
        } else {
            this.fieldCache = Collections.emptyMap();
        }
    }

    Field getField(String fname) {
        return this.fieldCache.get(fname);
    }

    String[] getFieldNames() {
        return this.fieldCache.keySet().toArray(new String[this.fieldCache.size()]);
    }

    String[] getMethodNames() {
        return this.byName.keySet().toArray(new String[this.byName.size()]);
    }

    Method[] getMethods(String methodName) {
        Method[] lm = this.byName.get(methodName);
        if (lm != null && lm.length > 0) {
            return (Method[])lm.clone();
        }
        return null;
    }

    Method getMethod(MethodKey methodKey) throws MethodKey.AmbiguousException {
        Method cacheEntry = (Method)this.byKey.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            try {
                Method[] methodList = this.byName.get(methodKey.getMethod());
                if (methodList != null) {
                    cacheEntry = methodKey.getMostSpecificMethod(methodList);
                }
                if (cacheEntry == null) {
                    this.byKey.put(methodKey, CACHE_MISS);
                } else {
                    this.byKey.put(methodKey, cacheEntry);
                }
            }
            catch (MethodKey.AmbiguousException ae) {
                this.byKey.put(methodKey, CACHE_MISS);
                throw ae;
            }
        }
        return cacheEntry;
    }

    private static void create(ClassMap cache, Class<?> classToReflect, Log log) {
        while (classToReflect != null) {
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                ClassMap.populateWithClass(cache, classToReflect, log);
            }
            Class<?>[] interfaces = classToReflect.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ClassMap.populateWithInterface(cache, interfaces[i], log);
            }
            classToReflect = classToReflect.getSuperclass();
        }
        if (!cache.byKey.isEmpty()) {
            ArrayList<Method> lm = new ArrayList<Method>(cache.byKey.size());
            for (Method method : cache.byKey.values()) {
                lm.add(method);
            }
            Collections.sort(lm, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            int start = 0;
            while (start < lm.size()) {
                String walk;
                int end;
                String name = ((Method)lm.get(start)).getName();
                for (end = start + 1; end < lm.size() && (walk = ((Method)lm.get(end)).getName()).equals(name); ++end) {
                }
                Method[] lmn = lm.subList(start, end).toArray(new Method[end - start]);
                cache.byName.put(name, lmn);
                start = end;
            }
        }
    }

    private static void populateWithInterface(ClassMap cache, Class<?> iface, Log log) {
        if (Modifier.isPublic(iface.getModifiers())) {
            ClassMap.populateWithClass(cache, iface, log);
        }
        Class<?>[] supers = iface.getInterfaces();
        for (int i = 0; i < supers.length; ++i) {
            ClassMap.populateWithInterface(cache, supers[i], log);
        }
    }

    private static void populateWithClass(ClassMap cache, Class<?> clazz, Log log) {
        block3: {
            try {
                Method[] methods = clazz.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method mi = methods[i];
                    if (!Modifier.isPublic(mi.getModifiers()) || !Permissions.allow(mi)) continue;
                    cache.byKey.putIfAbsent(new MethodKey(mi), mi);
                }
            }
            catch (SecurityException se) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("While accessing methods of " + clazz + ": ", se);
            }
        }
    }
}

