/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.servlet;

import com.google.gson.Gson;
import eu.toimproveit.saml.SAMLContext;
import eu.toimproveit.saml.SAMLTemplateRenderer;
import eu.toimproveit.saml.SAMLUtils;
import eu.toimproveit.saml.model.SAMLSettings;
import eu.toimproveit.saml.servlet.SAMLServlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLConfigServlet
extends SAMLServlet {
    private final Log log = LogFactory.getLog(SAMLConfigServlet.class);

    public abstract List<String> getHeaders();

    public abstract boolean isAdmin(HttpServletRequest var1);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            SAMLContext sAMLContext = new SAMLContext(this.config);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        resp.setContentType("text/html");
        if (this.isAdmin(req)) {
            String json = req.getParameter("json");
            String accept = req.getHeader("Accept");
            if (req.getParameter("spXml") != null) {
                this.download(resp, this.config.getSettings().getSpXml(), "saml-sp.xml");
                return;
            }
            if (req.getParameter("spCert") != null) {
                this.download(resp, this.config.getSettings().getSpCert(), "saml-sp.cert");
                return;
            }
            if (req.getParameter("debuglog") != null) {
                this.download(resp, this.config.getLogFilePath());
                return;
            }
            if (json != null || "application/json".equals(accept)) {
                String jsonSettings = new Gson().toJson((Object)this.config.getSettings(), (Type)((Object)SAMLSettings.class));
                this.download(resp, jsonSettings, "saml-config.json");
            } else {
                SAMLTemplateRenderer renderer = new SAMLTemplateRenderer();
                renderer.render(resp.getWriter(), "config.vm", this.config, this.getHeaders());
            }
        } else {
            resp.sendRedirect(SAMLUtils.getDefaultBaseURL(req));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isAdmin(req)) {
            try {
                SAMLContext sAMLContext = new SAMLContext(this.config);
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
            BufferedReader reader = req.getReader();
            Gson gson = new Gson();
            SAMLSettings samlSettings = gson.fromJson((Reader)reader, SAMLSettings.class);
            ArrayList<String> messages = new ArrayList<String>();
            int result = samlSettings.validate(this.config.getSettings(), messages);
            this.config.renewCertificate(samlSettings);
            this.config.saveSettings(samlSettings);
            samlSettings = this.config.getSettings();
            String jsonSettings = gson.toJson((Object)samlSettings, (Type)((Object)SAMLSettings.class));
            PrintWriter out = resp.getWriter();
            resp.setContentType("application/json");
            out.printf("{\"code\": %d, \"message\": \"%s\", \"settings\": %s}", result, String.join((CharSequence)", ", messages), jsonSettings);
            out.flush();
        } else {
            resp.sendRedirect(SAMLUtils.getDefaultBaseURL(req));
        }
    }

    private void download(HttpServletResponse resp, String value, String filename) throws IOException {
        if (value == null) {
            value = "";
        }
        PrintWriter out = resp.getWriter();
        resp.setHeader("Content-disposition", "attachment; filename=" + filename);
        resp.setContentType("application/json");
        out.println(value);
        out.flush();
    }

    private void download(HttpServletResponse resp, String filename) throws IOException {
        resp.setContentType("text/plain");
        File file = new File(filename);
        if (!file.exists()) {
            PrintWriter out = resp.getWriter();
            out.println("Logfile not found. Is debug log enabled?");
            out.flush();
            return;
        }
        resp.setHeader("Content-disposition", "attachment; filename=" + file.getName());
        try (FileInputStream in = new FileInputStream(filename);
             ServletOutputStream out = resp.getOutputStream();){
            int numBytesRead;
            byte[] buffer = new byte[1048];
            while ((numBytesRead = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, numBytesRead);
            }
        }
    }
}

