/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.servlet;

import eu.toimproveit.saml.servlet.SAMLServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLAvatarServlet
extends SAMLServlet {
    private Log log = LogFactory.getLog(SAMLAvatarServlet.class);

    protected abstract byte[] getUserAvatar(String var1);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String emailHash;
        byte[] imageByte;
        if (!this.config.hasValidLicense()) {
            this.write(resp, "Avatar servlet invalid license");
            return;
        }
        if (!this.config.avatarServletAvailable()) {
            this.write(resp, "Avatar servlet not available");
            return;
        }
        if (!this.config.getSettings().isEnableAvatarServlet()) {
            this.write(resp, "Avatar servlet is not enabled");
            return;
        }
        String[] parts = req.getPathInfo().split("/");
        if (parts.length < 2) {
            this.write(resp, "Avatar servlet missing path info");
            return;
        }
        String token = this.config.getSettings().getTokenAvatarServlet();
        if (StringUtils.isNotBlank(token)) {
            if (parts.length < 3) {
                this.write(resp, "Avatar servlet missing token");
                return;
            }
            String tokenPart = parts[parts.length - 2];
            if (!tokenPart.equals(token)) {
                this.write(resp, "Avatar servlet token does not match");
                return;
            }
        }
        if ((imageByte = this.getUserAvatar(emailHash = parts[parts.length - 1].split("\\.")[0])) != null) {
            resp.setContentType("image/png");
            resp.getOutputStream().write(imageByte);
        }
    }

    private void write(HttpServletResponse resp, String message) {
        this.log.info(message);
        resp.setContentType("text/html");
        try {
            resp.getWriter().write(message);
        }
        catch (IOException e) {
            this.log("Unable to write", e);
        }
    }
}

