/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.filter;

import eu.toimproveit.saml.SAMLUtils;
import eu.toimproveit.saml.filter.SAMLFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLLogoutFilter
extends SAMLFilter {
    private final Log log = LogFactory.getLog(SAMLLogoutFilter.class);

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.logout((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        if (!servletResponse.isCommitted()) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected void logout(HttpServletRequest request, HttpServletResponse response) {
        if (this.doLogout(request)) {
            this.log.info("SAML Logout");
            if (request == null || response == null) {
                this.log.error("HttpServletRequest or response is NULL");
                return;
            }
            SAMLUtils.resetLoggedIn(request, this.getSAMLUserId(request, response));
            SAMLUtils.logout(this.getSamlConfig(), request, response);
        }
    }

    protected boolean doLogout(HttpServletRequest request) {
        String queryString;
        boolean result = this.getSamlConfig().isSingleLogoutEnabled();
        if (result && (queryString = request.getQueryString()) != null && queryString.contains("loggedOut")) {
            result = false;
        }
        return result;
    }
}

