/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.filter;

import eu.toimproveit.saml.SAMLContext;
import eu.toimproveit.saml.filter.SAMLFilter;
import eu.toimproveit.saml.model.SAMLSettings;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SAMLLoginFilter
extends SAMLFilter {
    private Log log = LogFactory.getLog(SAMLLoginFilter.class);

    protected abstract String getLoginUri(HttpServletRequest var1);

    protected abstract boolean authenticateSAMLUser(HttpServletRequest var1, HttpServletResponse var2, String var3);

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean forceSAML;
        SAMLSettings settings;
        HttpServletResponse res;
        HttpServletRequest req;
        block15: {
            if (this.getSamlConfig() == null || this.skipFilter(request)) {
                chain.doFilter(request, response);
                return;
            }
            req = (HttpServletRequest)request;
            res = (HttpServletResponse)response;
            try {
                SAMLContext sAMLContext = new SAMLContext(this.getSamlConfig());
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
            settings = this.getSamlConfig().getSettings();
            forceSAML = settings.isForceSAML();
            String headerUserName = settings.getHeaderUserName();
            String headerTokenName = settings.getHeaderTokenName();
            String headerTokenValue = settings.getHeaderTokenValue();
            if (headerUserName != null && headerTokenName != null) {
                String httpHeaderUserName = req.getHeader(headerUserName);
                String httpHeaderTokenValue = req.getHeader(headerTokenName);
                if (StringUtils.isNotBlank(headerUserName) && StringUtils.isNotBlank(headerTokenName) && StringUtils.isNotBlank(headerTokenValue) && StringUtils.isNotBlank(httpHeaderUserName) && StringUtils.isNotBlank(httpHeaderTokenValue)) {
                    if (headerTokenValue.equals(httpHeaderTokenValue)) {
                        try {
                            this.log.info("Http header authentication found");
                            if (this.authenticateSAMLUser(req, res, httpHeaderUserName)) {
                                this.log.info("Http header authentication success");
                                forceSAML = false;
                                break block15;
                            }
                            this.log.info("Http header authentication failed");
                        }
                        catch (Exception e) {
                            this.log.error("saml plugin: error ", e);
                        }
                    } else {
                        this.log.info("Http header authentication mismatch.");
                    }
                } else {
                    this.log.info("Http header authentication missing. Continue without ...");
                }
            }
        }
        if (forceSAML) {
            forceSAML = this.checkForceSAML(req);
        }
        if (forceSAML) {
            String url = settings.getSamlEndPoint();
            url = url.contains("?") ? url + "&samlerror=forceSAML" : url + "?samlerror=forceSAML";
            String parameter = request.getParameter(this.getRedirectParameter());
            if (parameter != null) {
                url = url + String.format("&%s=%s", this.getRedirectParameter(), URLEncoder.encode(parameter, StandardCharsets.UTF_8.toString()));
            }
            res.sendRedirect(url);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected boolean skipFilter(ServletRequest request) {
        return false;
    }

    protected boolean checkForceSAML(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameter("noSSO") == null && httpServletRequest.getParameter("noSAML") == null && httpServletRequest.getParameter("samlerror") == null && httpServletRequest.getParameter("samlwarn") == null;
    }

    protected String getRedirectParameter() {
        return "os_destination";
    }
}

