/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml.bamboo.filter;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.search.page.Pager;
import eu.toimproveit.saml.SAMLConfig;
import eu.toimproveit.saml.bamboo.config.SAML4BambooConfig;
import eu.toimproveit.saml.bamboo.utils.SAMLLoginUtils;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestrictedLoginFilter
extends eu.toimproveit.saml.filter.RestrictedLoginFilter {
    private final Log log = LogFactory.getLog(RestrictedLoginFilter.class);
    private final SAMLLoginUtils loginUtils = new SAMLLoginUtils();
    private final UserManager userManager = (UserManager)ContainerManager.getComponent((String)"userManager");
    private final GroupManager groupManager = (GroupManager)ContainerManager.getComponent((String)"groupManager");
    private SAML4BambooConfig config;
    private LoginUriProvider loginUriProvider;

    @Inject
    public void setConfig(SAML4BambooConfig config) {
        this.config = config;
    }

    @Inject
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @Override
    protected SAMLConfig getSamlConfig() {
        return this.config;
    }

    @Override
    protected String getLoginUri(HttpServletRequest httpServletRequest) {
        return this.loginUtils.getLoginUri(this.loginUriProvider, httpServletRequest);
    }

    @Override
    protected boolean restrictLogin(HttpServletRequest request, String[] userGroups) {
        String formUser = request.getParameter("os_username");
        if (formUser == null || userGroups.length == 0) {
            return false;
        }
        try {
            User user = this.userManager.getUser(formUser);
            Pager groups = this.groupManager.getGroups(user);
            ArrayList groupsForUser = new ArrayList();
            groups.iterator().forEachRemaining(groupsForUser::add);
            for (Group groupForUser : groupsForUser) {
                for (String groupName : userGroups) {
                    if (!groupName.equals(groupForUser.getName())) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage());
        }
        return true;
    }
}

