/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import eu.toimproveit.saml.model.SAMLUserMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLUser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLUser.class);
    private String nameId;
    private Map<String, String[]> attributes = new HashMap<String, String[]>();
    private SAMLUserMapping samlUserMapping = new SAMLUserMapping();

    public String getNameId() {
        return this.nameId;
    }

    public void setNameId(String nameId) {
        this.nameId = nameId;
    }

    public Map<String, String[]> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String[]> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String key, String[] values) {
        this.attributes.put(key, values);
    }

    public SAMLUserMapping getSamlUserMapping() {
        return this.samlUserMapping;
    }

    public void setSamlUserMapping(SAMLUserMapping samlUserMapping) {
        this.samlUserMapping = samlUserMapping;
    }

    public String toString() {
        return "SAMLUser{NameId='" + this.nameId + '\'' + ", attributes=" + this.getAttributesString() + '}';
    }

    public String getAttributesString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean firstAttribute = true;
        if (this.attributes != null) {
            for (Map.Entry<String, String[]> attribute : this.attributes.entrySet()) {
                if (firstAttribute) {
                    firstAttribute = false;
                } else {
                    sb.append(",");
                }
                boolean firstValue = true;
                sb.append(attribute.getKey());
                sb.append(":[");
                for (String value : attribute.getValue()) {
                    if (firstValue) {
                        firstValue = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(" \"");
                    sb.append(value);
                    sb.append("\" ");
                }
                sb.append("]");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private String getValue(String fieldName) {
        if (fieldName == null || "NameId".equals(fieldName)) {
            return this.getNameId();
        }
        String[] values = new String[]{this.getValueFromExpression(fieldName)};
        if (values == null || values.length == 0) {
            return this.getNameId();
        }
        return values[0];
    }

    public String getValueFromExpression(String expression) {
        JexlEngine jexlEngine = new JexlBuilder().create();
        MapContext jexlContext = new MapContext();
        jexlContext.set("NameId", this.getNameId());
        Set<Map.Entry<String, String[]>> entries = this.attributes.entrySet();
        if (entries == null) {
            entries = new HashSet<Map.Entry<String, String[]>>();
        }
        int index = 0;
        for (Map.Entry<String, String[]> entry : entries) {
            String localVar = "toimproveit_var" + index;
            jexlContext.set(localVar, entry.getValue()[0]);
            expression = expression.replaceAll(entry.getKey(), localVar);
            ++index;
        }
        try {
            JexlScript jexlScript = jexlEngine.createScript(expression);
            return jexlScript.execute(jexlContext).toString();
        }
        catch (Exception e) {
            LOGGER.error("Error Evaluating Expression", (Throwable)e);
            return "";
        }
    }

    public String[] getValuesFromExpression(String expression) {
        JexlEngine jexlEngine = new JexlBuilder().create();
        MapContext jexlContext = new MapContext();
        jexlContext.set("NameId", this.getNameId());
        Set<Map.Entry<String, String[]>> entries = this.attributes.entrySet();
        if (entries == null) {
            entries = new HashSet<Map.Entry<String, String[]>>();
        }
        int index = 0;
        for (Map.Entry<String, String[]> entry : entries) {
            String localVar = "toimproveit_var" + index;
            String[] value = entry.getValue();
            if (value.length == 1) {
                jexlContext.set(localVar, value[0]);
            } else {
                jexlContext.set(localVar, value);
            }
            expression = expression.replaceAll(entry.getKey(), localVar);
            ++index;
        }
        try {
            JexlScript jexlScript = jexlEngine.createScript(expression);
            Object scriptResult = jexlScript.execute(jexlContext);
            if (scriptResult instanceof String) {
                return new String[]{(String)scriptResult};
            }
            String[] result = (String[])scriptResult;
            if (result == null) {
                return new String[0];
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error Evaluating Expression: %s", e.getMessage()));
            return new String[0];
        }
    }

    public String getUserId() {
        return this.getValue(this.samlUserMapping.getUseridField());
    }

    public String getEmail() {
        return this.getValue(this.samlUserMapping.getEmailField());
    }

    public String getUsername() {
        return this.getValue(this.samlUserMapping.getUsernameField());
    }

    public String[] getGroups() {
        if (this.samlUserMapping.getGroupsField() == null) {
            return new String[0];
        }
        String[] groups = this.getValuesFromExpression(this.samlUserMapping.getGroupsField());
        if (groups.length == 1) {
            groups = groups[0].split(",");
        }
        return groups;
    }

    public String getAvatarBase64() {
        String[] values = this.getValuesFromExpression(this.samlUserMapping.getAvatarField());
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public boolean isMemberOfUsergroups(String[] usergroups) {
        String[] groups;
        for (String group : groups = this.getGroups()) {
            for (String usergroup : usergroups) {
                if (!this.trimQuotes(usergroup).equals(group)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAllowedToUsergroups(String allowedUsergroups) {
        if (allowedUsergroups == null || allowedUsergroups.trim().length() == 0) {
            return true;
        }
        if ("*".equals(allowedUsergroups.trim())) {
            return true;
        }
        if ("+".equals(allowedUsergroups.trim()) && this.getGroups().length > 0) {
            return true;
        }
        String[] usergroups = this.splitByCommaNotInQuote(allowedUsergroups);
        return this.isMemberOfUsergroups(usergroups);
    }

    public String[] splitByCommaNotInQuote(String string) {
        return string.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
    }

    public String trimQuotes(String string) {
        return string.replaceAll("^\"(.*)\"$", "$1");
    }
}

