/*
 * Decompiled with CFR 0.152.
 */
package eu.toimproveit.saml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;

public class KeystoreUtils {
    private final Log log = LogFactory.getLog(KeystoreUtils.class);
    private static final int KEY_SIZE = 1024;

    public KeystoreUtils() {
        Security.addProvider(new BouncyCastleProvider());
    }

    public KeyStore getKeyStore(File directory, String idpEntityId) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = "changeit".toCharArray();
        try {
            File file = new File(directory, "saml/samlKeystore.jks");
            FileInputStream fis = null;
            if (file.exists()) {
                fis = new FileInputStream(file);
            }
            ks.load(fis, password);
            if (!file.exists()) {
                this.log.info("Key store does not exist. Creating ...");
                String name = "CN=" + idpEntityId;
                this.doGenKeyPair(ks, "saml", name, "RSA", 1024, null, password, 3650L, new Date());
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                ks.store(fos, password);
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
        return ks;
    }

    public boolean removeKeystore(File directory) {
        File file = new File(directory, "saml/samlKeystore.jks");
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    private void doGenKeyPair(KeyStore keyStore, String alias, String dname, String keyAlgName, int keysize, String sigAlgName, char[] keyPass, long validity, Date startDate) throws Exception {
        if (keysize == -1) {
            keysize = "EC".equalsIgnoreCase(keyAlgName) ? 256 : 1024;
        }
        if (keyStore.containsAlias(alias)) {
            MessageFormat form = new MessageFormat("Key pair not generated, alias <alias> already exists");
            Object[] source = new Object[]{alias};
            throw new Exception(form.format(source));
        }
        if (sigAlgName == null) {
            if ("DSA".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithDSA";
            } else if ("RSA".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1WithRSA";
            } else if ("EC".equalsIgnoreCase(keyAlgName)) {
                sigAlgName = "SHA1withECDSA";
            } else {
                throw new Exception("Cannot derive signature algorithm");
            }
        }
        KeyPair keyPair = this.generateRSAKeyPair();
        Certificate[] chain = new X509Certificate[1];
        long time = System.currentTimeMillis() - 10000L;
        Date now = new Date(time);
        Date expiryDate = new Date(time + 315360000000L);
        chain[0] = this.generateSelfSignedCertificate(keyPair, sigAlgName, now, expiryDate, dname);
        RSAPrivateKey priv = (RSAPrivateKey)keyPair.getPrivate();
        keyStore.setKeyEntry(alias, priv, keyPass, chain);
    }

    private KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.log.debug("Generate RSAKeyPair");
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        this.log.debug("Return keyPair");
        return keyPair;
    }

    private X509Certificate generateSelfSignedCertificate(KeyPair keyPair, String signatureAlgorithm, Date startDate, Date expiryDate, String dname) throws NoSuchAlgorithmException, CertificateEncodingException, NoSuchProviderException, InvalidKeyException, SignatureException {
        BigInteger serialNumber = BigInteger.valueOf(1L);
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal(dname);
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm(signatureAlgorithm);
        X509Certificate cert = certGen.generate(keyPair.getPrivate(), "BC");
        return cert;
    }

    public String getCertificate(KeyStore ks) throws Exception {
        Certificate cert = ks.getCertificate("saml");
        Base64.Encoder encoder = Base64.getMimeEncoder(64, System.getProperty("line.separator").getBytes());
        byte[] rawCrtText = cert.getEncoded();
        String encodedCertText = new String(encoder.encode(rawCrtText));
        return encodedCertText;
    }

    public String getValidString(String certificate) {
        if (certificate == null || certificate.length() < 64) {
            return "";
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
            if (cert != null) {
                return String.format("valid from: %s until: %s", cert.getNotBefore().toString(), cert.getNotAfter().toString());
            }
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        return "";
    }
}

