/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.upgradetask;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.xpandit.xray.upgradetask.XrayUpgradeTask;
import com.xpandit.xray.util.XrayUpgradeTaskException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class UpgradeTaskEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTaskEventListener.class);
    private static final String PLUGIN_ID = "com.xpandit.plugins.xray-bamboo";
    private static final String XRAY_LAST_UPGRADE_TASK_EXECUTED = "com.xpandit.xray.xraylastupgradetaskexecuted";
    private final EventPublisher eventPublisher;
    private final PluginSettings pluginSettings;
    private final PluginAccessor pluginAccessor;

    public UpgradeTaskEventListener(EventPublisher eventPublisher, PluginSettingsFactory pluginSettingsFactory, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginAccessor = pluginAccessor;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_ID.equals(event.getPlugin().getKey())) {
            this.executeUpgradeTasks();
        }
    }

    private void executeUpgradeTasks() {
        int lastUpgradeTaskExecuted = this.getLastUpgradeTaskExecuted();
        List upgradeTasks = Optional.ofNullable(this.pluginAccessor.getEnabledModulesByClass(XrayUpgradeTask.class)).orElseGet(Collections::emptyList);
        upgradeTasks.stream().filter(upgradeTask -> upgradeTask.getUpgradeTaskNumber() > lastUpgradeTaskExecuted).sorted(Comparator.comparingInt(XrayUpgradeTask::getUpgradeTaskNumber)).forEachOrdered(this::executeAndIncreaseNumber);
    }

    private void executeAndIncreaseNumber(XrayUpgradeTask xrayUpgradeTask) {
        try {
            xrayUpgradeTask.execute();
            this.updateLastUpgradeTaskExecutedSettings(xrayUpgradeTask.getUpgradeTaskNumber());
        }
        catch (Exception e) {
            logger.error("Error occurred while executing Upgrade Task #{}", (Object)xrayUpgradeTask.getUpgradeTaskNumber(), (Object)e);
            throw new XrayUpgradeTaskException(e);
        }
    }

    private int getLastUpgradeTaskExecuted() {
        return this.getLastUpgradeTaskExecutedSettings().orElse(0);
    }

    private void updateLastUpgradeTaskExecutedSettings(int upgradeTaskNumber) {
        this.pluginSettings.put(XRAY_LAST_UPGRADE_TASK_EXECUTED, (Object)String.valueOf(upgradeTaskNumber));
    }

    private Optional<Integer> getLastUpgradeTaskExecutedSettings() {
        String lastUpgradeTask = (String)this.pluginSettings.get(XRAY_LAST_UPGRADE_TASK_EXECUTED);
        return Optional.ofNullable(lastUpgradeTask).map(Integer::valueOf);
    }
}

