/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.xpandit.xray.configuration.ServerConfig;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ExportCucumberFeaturesTaskConfigurator
extends AbstractTaskConfigurator {
    public static final String SERVER_PARAM = "server";
    public static final String SERVER_MAP_PARAM = "serverMap";
    public static final String ISSUES_PARAM = "issues";
    public static final String FILTER_PARAM = "filter";
    public static final String FILEPATH_PARAM = "filePath";
    private final ServerConfig serverConfig;
    private final I18nResolver i18n;

    public ExportCucumberFeaturesTaskConfigurator(ServerConfig serverConfig, I18nResolver i18n) {
        this.serverConfig = serverConfig;
        this.i18n = i18n;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(SERVER_PARAM, params.getString(SERVER_PARAM));
        config.put(ISSUES_PARAM, params.getString(ISSUES_PARAM));
        config.put(FILTER_PARAM, params.getString(FILTER_PARAM));
        config.put(FILEPATH_PARAM, params.getString(FILEPATH_PARAM));
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String configID;
        super.validate(params, errorCollection);
        String issuesValue = params.getString(ISSUES_PARAM);
        String filterValue = params.getString(FILTER_PARAM);
        String filePathValue = params.getString(FILEPATH_PARAM);
        if (issuesValue != null && StringUtils.isEmpty((CharSequence)issuesValue) && StringUtils.isEmpty((CharSequence)filterValue)) {
            errorCollection.addError(ISSUES_PARAM, this.i18n.getText("export-cucumber-features.issues-filter-param-required"));
        }
        if (filePathValue != null && filePathValue.contains("../")) {
            errorCollection.addError(FILEPATH_PARAM, this.i18n.getText("export-cucumber-features.filepath-param-error"));
        }
        if ((configID = params.getString(SERVER_PARAM)) != null && configID.equals("-1")) {
            errorCollection.addError(SERVER_PARAM, this.i18n.getText("export-cucumber-features.serverpath-param-error-noconfig"));
        }
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        Map<String, String> servers = this.serverConfig.getServers();
        context.put(SERVER_MAP_PARAM, servers);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map<String, String> servers = this.serverConfig.getServers();
        context.put(SERVER_MAP_PARAM, servers);
        context.put(SERVER_PARAM, taskDefinition.getConfiguration().get(SERVER_PARAM));
        context.put(ISSUES_PARAM, taskDefinition.getConfiguration().get(ISSUES_PARAM));
        context.put(FILTER_PARAM, taskDefinition.getConfiguration().get(FILTER_PARAM));
        context.put(FILEPATH_PARAM, taskDefinition.getConfiguration().get(FILEPATH_PARAM));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put(ISSUES_PARAM, taskDefinition.getConfiguration().get(ISSUES_PARAM));
        context.put(FILTER_PARAM, taskDefinition.getConfiguration().get(FILTER_PARAM));
        context.put(FILEPATH_PARAM, taskDefinition.getConfiguration().get(FILEPATH_PARAM));
    }
}

