/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.bean;

import com.xpandit.xray.service.impl.bean.RavenResult;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;

public class ConnectionResult
extends RavenResult {
    private final boolean isSuccessful;
    private final String errorText;
    private final Integer statusCode;

    private ConnectionResult(boolean bl, String string, Integer n) {
        this.isSuccessful = bl;
        this.errorText = StringUtils.defaultString((String)string);
        this.statusCode = n;
    }

    public static ConnectionResult connectionSuccessful() {
        return new ConnectionResult(true, "", 200);
    }

    public static ConnectionResult connectionFailed(String string) {
        return new ConnectionResult(false, string, null);
    }

    public static ConnectionResult connectionFailed(String string, Integer n) {
        return new ConnectionResult(false, string, n);
    }

    public static ConnectionResult connectionFailed(Throwable throwable) {
        return ConnectionResult.connectionFailed(ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    public static ConnectionResult connectionFailed(CloseableHttpResponse closeableHttpResponse) {
        String string = "";
        Integer n = null;
        if (closeableHttpResponse != null) {
            string = ConnectionResult.handleResponseAsString((HttpResponse)closeableHttpResponse);
            n = closeableHttpResponse.getStatusLine().getStatusCode();
        }
        return ConnectionResult.connectionFailed(string, n);
    }

    @Override
    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public Optional<Integer> getStatusCode() {
        return Optional.ofNullable(this.statusCode);
    }
}

