/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.service.XrayServerCredentials;
import com.xpandit.xray.service.impl.bean.ConnectionResult;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.service.impl.delegates.HttpServerRequestProvider;
import com.xpandit.xray.service.impl.delegates.authentication.AuthenticationMethod;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class XrayClientImpl
implements XrayServerCredentials {
    private static final String JIRA_SERVER_INFO_PATH = "/rest/api/2/serverInfo";
    private static final String JIRA_SERVER_CURRENT_USER_PATH = "/rest/auth/1/session";
    private static final Logger logger = LogManager.getLogger(XrayClientImpl.class);
    private final HttpServerRequestProvider httpProvider;

    public XrayClientImpl(String string, AuthenticationMethod authenticationMethod, HttpRequestProvider.ProxyBean proxyBean) {
        this.httpProvider = new HttpServerRequestProvider(string, authenticationMethod, proxyBean);
    }

    @Override
    public ConnectionResult testConnection() {
        ConnectionResult connectionResult = ConnectionResult.connectionSuccessful();
        if (!this.isJiraInstance().isSuccessful()) {
            connectionResult = ConnectionResult.connectionFailed("URL must be from a Jira instance (check if your /serverInfo endpoint is not blocked)", connectionResult.getStatusCode().orElse(null));
        } else {
            try (CloseableHttpResponse closeableHttpResponse = this.httpProvider.doGetRequest(this.getJiraURL() + JIRA_SERVER_CURRENT_USER_PATH);){
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                if (n != 200) {
                    connectionResult = ConnectionResult.connectionFailed(closeableHttpResponse);
                }
            }
            catch (XrayClientCoreGenericException | IOException exception) {
                logger.error("An error occurred while connecting to Jira Server", (Throwable)exception);
                connectionResult = ConnectionResult.connectionFailed(exception);
            }
        }
        return connectionResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConnectionResult isJiraInstance() {
        try (CloseableHttpResponse closeableHttpResponse = this.httpProvider.doGetRequest(this.getJiraURL() + JIRA_SERVER_INFO_PATH);){
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n == 200 && this.isJiraServerInfoValid(closeableHttpResponse)) {
                ConnectionResult connectionResult2 = ConnectionResult.connectionSuccessful();
                return connectionResult2;
            }
            ConnectionResult connectionResult = ConnectionResult.connectionFailed("An error occurred while making the connection to Jira Server (isJiraInstance)", n);
            return connectionResult;
        }
        catch (Exception exception) {
            logger.error("An error occurred while making the connection to Jira Server (isJiraInstance)", (Throwable)exception);
            return ConnectionResult.connectionFailed("An error occurred while making the connection to Jira Server (isJiraInstance)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJiraServerInfoValid(CloseableHttpResponse closeableHttpResponse) {
        try (InputStream inputStream = closeableHttpResponse.getEntity().getContent();){
            String string = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            if (!StringUtils.isNotBlank((CharSequence)string)) return false;
            JSONObject jSONObject = new JSONObject(string);
            boolean bl = jSONObject.has("baseUrl") && jSONObject.has("version") && jSONObject.has("versionNumbers") && jSONObject.has("deploymentType") && jSONObject.has("buildNumber") && jSONObject.has("buildDate") && jSONObject.has("scmInfo") && jSONObject.has("serverTitle");
            return bl;
        }
        catch (IOException iOException) {
            logger.error("An error occurred while parsing response from Jira Server", (Throwable)iOException);
        }
        return false;
    }

    @Override
    public String getJiraURL() {
        return this.httpProvider.getJiraURL();
    }

    public HttpRequestProvider getHttpProvider() {
        return this.httpProvider;
    }
}

