/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.util;

import com.xpandit.xray.model.UploadResult;
import java.util.Date;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.utils.DateUtils;

public class UploadResultUtil {
    public static final long MAX_RETRY_AFTER_TIME_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    private UploadResultUtil() {
    }

    public static OptionalLong getRetryTime(UploadResult uploadResult2) {
        Optional optional = Optional.ofNullable(uploadResult2).flatMap(uploadResult -> uploadResult.getHeaderValue("Retry-After"));
        if (!optional.isPresent()) {
            return OptionalLong.empty();
        }
        return optional.filter(NumberUtils::isParsable).map(Double::parseDouble).map(Math::ceil).map(Double::longValue).map(OptionalLong::of).orElseGet(() -> UploadResultUtil.getRetryTimeFromDateValue((String)optional.get()));
    }

    private static OptionalLong getRetryTimeFromDateValue(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return OptionalLong.empty();
        }
        Date date = DateUtils.parseDate((String)string);
        if (date != null) {
            long l = TimeUnit.MILLISECONDS.toSeconds(date.getTime() - new Date().getTime());
            return OptionalLong.of(Math.max(0L, l));
        }
        return OptionalLong.empty();
    }
}

