/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.servlet;

import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.xpandit.xray.configuration.ServerConfig;
import com.xpandit.xray.model.CredentialData;
import com.xpandit.xray.service.impl.XrayClientImpl;
import com.xpandit.xray.service.impl.delegates.authentication.UsernamePasswordAuthentication;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminServlet
extends HttpServlet {
    private static final String CREDENTIAL_LIST = "credentialList";
    private static final String ROWID = "ROWID";
    private static final String TYPE = "type";
    private static final String ADD_TYPE = "add";
    private static final String REMOVE_TYPE = "remove";
    private static final String EDIT_TYPE = "edit";
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer templateRenderer;
    private final ServerConfig serverConfig;
    private final I18nBeanFactory i18n;

    public AdminServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer templateRenderer, ServerConfig serverConfig, I18nBeanFactory i18n) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.templateRenderer = templateRenderer;
        this.serverConfig = serverConfig;
        this.i18n = i18n;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = this.userManager.getRemoteUsername(request);
        if (username == null || !this.userManager.isSystemAdmin(username)) {
            this.redirectToLogin(request, response);
            return;
        }
        HashMap<String, List<CredentialData>> builder = new HashMap<String, List<CredentialData>>();
        List<CredentialData> credentialResult = this.serverConfig.getPluginSettings();
        builder.put(CREDENTIAL_LIST, credentialResult);
        response.setContentType("text/html; charset=utf-8");
        this.templateRenderer.render("templates/xray-bamboo-config.vm", builder, (Writer)response.getWriter());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String serverBaseUrl;
        String username = this.userManager.getRemoteUsername(request);
        if (username == null || !this.userManager.isSystemAdmin(username)) {
            this.redirectToLogin(request, response);
            return;
        }
        HashMap<String, Object> builder = new HashMap<String, Object>();
        HashMap<String, String> credentialMap = new HashMap<String, String>();
        credentialMap.put(TYPE, request.getParameter(TYPE));
        credentialMap.put(ROWID, request.getParameter(ROWID));
        credentialMap.put("name", request.getParameter("name"));
        ArrayList<String> i18nArgs = new ArrayList<String>();
        i18nArgs.add((String)credentialMap.get("name"));
        if (ADD_TYPE.equals(credentialMap.get(TYPE))) {
            serverBaseUrl = request.getParameter("server-address");
            credentialMap.put("serverAddress", serverBaseUrl);
            credentialMap.put("user", request.getParameter("user"));
            credentialMap.put("password", request.getParameter("password"));
            UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication((String)credentialMap.get("user"), (String)credentialMap.get("password"));
            boolean isValidJiraInstance = new XrayClientImpl(serverBaseUrl, usernamePasswordAuthentication, null).isJiraInstance().isSuccessful();
            if (!isValidJiraInstance) {
                builder.put("error", this.i18n.getI18nBean().getText("config.actions.add.error.non-jira", i18nArgs));
            } else if (!this.serverConfig.savePluginSettings(credentialMap)) {
                builder.put("error", this.i18n.getI18nBean().getText("config.actions.add.error", i18nArgs));
            } else {
                builder.put("success", this.i18n.getI18nBean().getText("config.actions.add.success", i18nArgs));
            }
        } else if (EDIT_TYPE.equals(credentialMap.get(TYPE))) {
            serverBaseUrl = request.getParameter("server-address");
            credentialMap.put("serverAddress", serverBaseUrl);
            credentialMap.put("user", request.getParameter("user"));
            credentialMap.put("password", request.getParameter("password"));
            UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication((String)credentialMap.get("user"), (String)credentialMap.get("password"));
            boolean isValidJiraInstance = new XrayClientImpl(serverBaseUrl, usernamePasswordAuthentication, null).isJiraInstance().isSuccessful();
            if (!isValidJiraInstance) {
                builder.put("error", this.i18n.getI18nBean().getText("config.actions.edit.error.non-jira", i18nArgs));
            } else if (!this.serverConfig.editPluginSettings(credentialMap)) {
                builder.put("error", this.i18n.getI18nBean().getText("config.actions.edit.error", i18nArgs));
            } else {
                builder.put("success", this.i18n.getI18nBean().getText("config.actions.edit.success", i18nArgs));
            }
        } else if (REMOVE_TYPE.equals(credentialMap.get(TYPE))) {
            this.serverConfig.removePluginSettings(credentialMap);
            builder.put("success", this.i18n.getI18nBean().getText("config.actions.remove.success", i18nArgs));
        }
        List<CredentialData> credentialResult = this.serverConfig.getPluginSettings();
        builder.put(CREDENTIAL_LIST, credentialResult);
        response.setContentType("text/html; charset=utf-8");
        this.templateRenderer.render("templates/xray-bamboo-config.vm", builder, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

