/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.service.impl.delegates.authentication.AuthenticationMethod;
import org.apache.http.HttpMessage;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;

public class HttpServerRequestProvider
extends HttpRequestProvider {
    private final AuthenticationMethod authenticationMethod;
    private final String jiraURL;

    public HttpServerRequestProvider(String string, AuthenticationMethod authenticationMethod, HttpRequestProvider.ProxyBean proxyBean) {
        super(proxyBean);
        this.jiraURL = string;
        this.authenticationMethod = authenticationMethod;
    }

    @Override
    public HttpGet prepareHttpGetHeader(String string) {
        HttpGet httpGet = new HttpGet(string);
        this.authenticationMethod.setAuthenticationHeader((HttpMessage)httpGet);
        return httpGet;
    }

    @Override
    public HttpPost prepareHttpPostHeader(String string) {
        HttpPost httpPost = new HttpPost(string);
        this.authenticationMethod.setAuthenticationHeader((HttpMessage)httpPost);
        return httpPost;
    }

    public String getJiraURL() {
        return this.jiraURL;
    }

    @Override
    public String getBaseUrl() {
        return this.jiraURL;
    }

    @Override
    public String getEndpointImportPrefix() {
        return "/rest/raven/1.0/import/execution";
    }

    @Override
    public String getEndpointExportFeaturesPrefix() {
        return "/rest/raven/1.0/export/test";
    }

    @Override
    public String getEndpointImportFeaturesPrefix() {
        return "/rest/raven/1.0/import/feature";
    }
}

