/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpCloudRequestProvider
extends HttpRequestProvider {
    private String token;
    private String clientId;
    private String clientSecret;
    private final String cloudUrl;
    private static Logger logger = LogManager.getLogger(HttpCloudRequestProvider.class);

    public HttpCloudRequestProvider(String string, HttpRequestProvider.ProxyBean proxyBean) {
        super(proxyBean);
        this.token = string;
        this.cloudUrl = this.getXrayCloudUrl();
    }

    public HttpCloudRequestProvider(String string, String string2, HttpRequestProvider.ProxyBean proxyBean) {
        super(proxyBean);
        this.clientId = string;
        this.clientSecret = string2;
        this.cloudUrl = this.getXrayCloudUrl();
    }

    @Override
    public HttpGet prepareHttpGetHeader(String string) {
        if (this.token == null) {
            return new HttpGet(string);
        }
        HttpGet httpGet = new HttpGet(string);
        httpGet.setHeader("Authorization", "Bearer " + this.token);
        return httpGet;
    }

    @Override
    public HttpPost prepareHttpPostHeader(String string) {
        logger.info("token: " + this.token);
        if (this.token == null) {
            return new HttpPost(string);
        }
        HttpPost httpPost = new HttpPost(string);
        httpPost.setHeader("Authorization", "Bearer " + this.token);
        return httpPost;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String string) {
        this.clientId = string;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String string) {
        this.clientSecret = string;
    }

    @Override
    public String getBaseUrl() {
        return this.cloudUrl;
    }

    @Override
    public String getEndpointImportPrefix() {
        return "/api/v1/import/execution";
    }

    @Override
    public String getEndpointExportFeaturesPrefix() {
        return "/api/v1/export/cucumber";
    }

    @Override
    public String getEndpointImportFeaturesPrefix() {
        return "/api/v1/import/feature";
    }

    private String getXrayCloudUrl() {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("constants.properties");
        if (inputStream == null) {
            throw new XrayClientCoreGenericException("Error loading properties file");
        }
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new XrayClientCoreGenericException("Exception error when loading properties file");
        }
        return properties.getProperty("xrayCloudUrl");
    }
}

