/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.bean;

import com.xpandit.xray.service.impl.bean.ConnectionResult;
import com.xpandit.xray.service.impl.bean.RavenResult;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;

public class TokenGenerationResult
extends RavenResult {
    private final ConnectionResult connectionResult;
    private final String token;

    private TokenGenerationResult(ConnectionResult connectionResult, String string) {
        this.connectionResult = connectionResult;
        this.token = string;
    }

    public static TokenGenerationResult successful(String string) {
        Objects.requireNonNull(string, "Token can't be null");
        return new TokenGenerationResult(ConnectionResult.connectionSuccessful(), string);
    }

    public static TokenGenerationResult failed(Throwable throwable) {
        return new TokenGenerationResult(ConnectionResult.connectionFailed(throwable), null);
    }

    public static TokenGenerationResult failed(CloseableHttpResponse closeableHttpResponse) {
        String string = "";
        if (closeableHttpResponse != null) {
            string = TokenGenerationResult.handleResponseAsString((HttpResponse)closeableHttpResponse);
        }
        return new TokenGenerationResult(ConnectionResult.connectionFailed(string), null);
    }

    @Override
    public boolean isSuccessful() {
        return this.connectionResult.isSuccessful();
    }

    public ConnectionResult getConnectionResult() {
        return this.connectionResult;
    }

    public String getToken() {
        return this.token;
    }
}

