/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xpandit.xray.configuration.ServerConfig;
import com.xpandit.xray.model.DataParameter;
import com.xpandit.xray.model.Endpoint;
import com.xpandit.xray.model.FormatBean;
import com.xpandit.xray.model.QueryParameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ImportResultsTaskConfigurator
extends AbstractTaskConfigurator {
    public static final String SERVER_PARAM = "importServer";
    public static final String SERVER_MAP_PARAM = "serverMap";
    public static final String FORMAT_PARAM = "format";
    public static final String FORMAT_LIST_PARAM = "formatList";
    public static final String FORMATS = "formats";
    public static final String INFO_SWITCHER = "inputInfoSwitcher";
    private final ServerConfig serverConfig;
    private final I18nResolver i18n;
    private static final Gson gson = new GsonBuilder().create();

    public ImportResultsTaskConfigurator(ServerConfig serverConfig, I18nResolver i18n) {
        this.serverConfig = serverConfig;
        this.i18n = i18n;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(SERVER_PARAM, params.getString(SERVER_PARAM));
        config.put(FORMAT_PARAM, params.getString(FORMAT_PARAM));
        for (DataParameter dataParameter : DataParameter.values()) {
            if (params.getString(dataParameter.getKey()) == null) continue;
            config.put(dataParameter.getKey(), params.getString(dataParameter.getKey()));
        }
        for (Enum enum_ : QueryParameter.values()) {
            if (params.getString(((QueryParameter)enum_).getKey()) == null) continue;
            config.put(((QueryParameter)enum_).getKey(), params.getString(((QueryParameter)enum_).getKey()));
        }
        config.put(INFO_SWITCHER, params.getString(INFO_SWITCHER));
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String configID;
        super.validate(params, errorCollection);
        String filePathValue = params.getString(DataParameter.FILEPATH.getKey());
        if (filePathValue != null && filePathValue.contains("../")) {
            errorCollection.addError(DataParameter.FILEPATH.getKey(), this.i18n.getText("import-cucumber-features.filepath-param-error-upperdirectories"));
        }
        if ((configID = params.getString(SERVER_PARAM)) != null && configID.equals("-1")) {
            errorCollection.addError(SERVER_PARAM, this.i18n.getText("import-cucumber-features.serverpath-param-error-noconfig"));
        }
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        Map<String, String> servers = this.serverConfig.getServers();
        LinkedHashMap<String, String> formatList = new LinkedHashMap<String, String>();
        LinkedHashMap<String, FormatBean> formats = new LinkedHashMap<String, FormatBean>();
        for (Endpoint endpoint : this.getXrayServerExclusiveEndpoints()) {
            formatList.put(endpoint.getName(), endpoint.getSuffix());
            formats.put(endpoint.getName(), endpoint.toBean());
        }
        context.put(SERVER_MAP_PARAM, servers);
        context.put(FORMAT_LIST_PARAM, formatList);
        context.put(FORMATS, gson.toJson(formats));
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map<String, String> servers = this.serverConfig.getServers();
        LinkedHashMap<String, String> formatList = new LinkedHashMap<String, String>();
        LinkedHashMap<String, FormatBean> formats = new LinkedHashMap<String, FormatBean>();
        String formatConfiguration = (String)taskDefinition.getConfiguration().get(FORMAT_PARAM);
        for (Endpoint endpoint : this.getXrayServerExclusiveEndpoints()) {
            formatList.put(endpoint.getName(), endpoint.getSuffix());
            FormatBean formatBean = endpoint.toBean();
            if (formatConfiguration.equals(endpoint.getSuffix())) {
                formatBean.setFieldsConfiguration(taskDefinition.getConfiguration());
            }
            formats.put(endpoint.getName(), formatBean);
        }
        context.put(SERVER_MAP_PARAM, servers);
        context.put(FORMAT_LIST_PARAM, formatList);
        context.put(FORMATS, gson.toJson(formats));
        context.put(SERVER_PARAM, taskDefinition.getConfiguration().get(SERVER_PARAM));
        context.put(FORMAT_PARAM, formatConfiguration);
        context.put(INFO_SWITCHER, taskDefinition.getConfiguration().get(INFO_SWITCHER));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
    }

    private List<Endpoint> getXrayServerExclusiveEndpoints() {
        Set<String> xrayCloudExclusiveEndpointSuffixes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Endpoint.getExclusiveCloudEndpoints())));
        return Stream.of(Endpoint.values()).filter(endpoint -> !xrayCloudExclusiveEndpointSuffixes.contains(endpoint.getSuffix())).sorted(Comparator.comparing(Endpoint::getName)).collect(Collectors.toList());
    }
}

