/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.model.Content;
import com.xpandit.xray.model.DataParameter;
import com.xpandit.xray.model.Endpoint;
import com.xpandit.xray.model.FilePath;
import com.xpandit.xray.model.QueryParameter;
import com.xpandit.xray.model.StringContent;
import com.xpandit.xray.model.UploadResult;
import com.xpandit.xray.service.impl.XrayImporterImpl;
import com.xpandit.xray.service.impl.delegates.authentication.UsernamePasswordAuthentication;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ImportResultsTask
implements TaskType {
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Import test result files Task started...");
        buildLogger.addBuildLogEntry("##########################################################");
        buildLogger.addBuildLogEntry("####   Xray for Jira is importing test result files ####");
        buildLogger.addBuildLogEntry("##########################################################");
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed();
        String taskFullID = taskContext.getBuildContext().getPlanResultKey().getPlanKey() + "-" + taskContext.getId();
        String serverAddress = (String)taskContext.getBuildContext().getBuildResult().getCustomBuildData().get(taskFullID + "serverAddress");
        String username = (String)taskContext.getBuildContext().getBuildResult().getCustomBuildData().get(taskFullID + "user");
        String password = (String)taskContext.getBuildContext().getBuildResult().getCustomBuildData().get(taskFullID + "password");
        if (StringUtils.isBlank((CharSequence)serverAddress) || StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            buildLogger.addErrorLogEntry("No valid Jira instance configuration found for this task. Please associate a valid configuration");
            return builder.build();
        }
        buildLogger.addBuildLogEntry("Uploading content to Jira instance: " + serverAddress);
        HashMap<DataParameter, Content> data = new HashMap<DataParameter, Content>();
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        String formatSuffix = (String)taskContext.getConfigurationMap().get((Object)"format");
        buildLogger.addBuildLogEntry("format endpoint: " + formatSuffix);
        String filePath = (String)taskContext.getConfigurationMap().get((Object)DataParameter.FILEPATH.getKey());
        String infoFieldValue = (String)taskContext.getConfigurationMap().get((Object)DataParameter.INFO.getKey());
        String testInfoFieldValue = (String)taskContext.getConfigurationMap().get((Object)DataParameter.TEST_INFO.getKey());
        String projectKey = (String)taskContext.getConfigurationMap().get((Object)QueryParameter.PROJECT_KEY.getKey());
        queryParams.put(QueryParameter.PROJECT_KEY, projectKey);
        String testExecKey = (String)taskContext.getConfigurationMap().get((Object)QueryParameter.TEST_EXEC_KEY.getKey());
        queryParams.put(QueryParameter.TEST_EXEC_KEY, testExecKey);
        String testPlanKey = (String)taskContext.getConfigurationMap().get((Object)QueryParameter.TEST_PLAN_KEY.getKey());
        queryParams.put(QueryParameter.TEST_PLAN_KEY, testPlanKey);
        String environments = (String)taskContext.getConfigurationMap().get((Object)QueryParameter.TEST_ENVIRONMENTS.getKey());
        queryParams.put(QueryParameter.TEST_ENVIRONMENTS, environments);
        String revision = (String)taskContext.getConfigurationMap().get((Object)QueryParameter.REVISION.getKey());
        queryParams.put(QueryParameter.REVISION, revision);
        String fixVersion = (String)taskContext.getConfigurationMap().get((Object)QueryParameter.FIX_VERSION.getKey());
        queryParams.put(QueryParameter.FIX_VERSION, fixVersion);
        XrayImporterImpl client = new XrayImporterImpl(serverAddress, new UsernamePasswordAuthentication(username, password), null);
        Endpoint endpoint = Endpoint.lookupBySuffix(formatSuffix);
        try {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                FilePath results = new FilePath(this.getReportFile(builder, taskContext, filePath).getAbsolutePath(), endpoint.getResultsMediaType());
                data.put(DataParameter.FILEPATH, results);
            }
            if (StringUtils.isNotBlank((CharSequence)infoFieldValue)) {
                String selectedInputType = (String)taskContext.getConfigurationMap().get((Object)"inputInfoSwitcher");
                Content<String> info = selectedInputType.equals("filePath") ? new FilePath(this.getFile(builder, taskContext, infoFieldValue).getAbsolutePath(), endpoint.getInfoFieldMediaType()) : new StringContent(infoFieldValue, endpoint.getInfoFieldMediaType());
                data.put(DataParameter.INFO, info);
            }
            if (StringUtils.isNotBlank((CharSequence)testInfoFieldValue)) {
                FilePath testInfo = new FilePath(this.getFile(builder, taskContext, testInfoFieldValue).getAbsolutePath(), endpoint.getInfoFieldMediaType());
                data.put(DataParameter.TEST_INFO, testInfo);
            }
            UploadResult uploadResult = client.uploadResults(endpoint, data, queryParams);
            Optional.ofNullable(uploadResult).ifPresent(result -> this.logUploadResult(buildLogger, (UploadResult)result));
        }
        catch (XrayClientCoreGenericException | IOException e) {
            buildLogger.addErrorLogEntry(e.getMessage());
            e.printStackTrace();
            return builder.build();
        }
        builder.success();
        buildLogger.addBuildLogEntry("Import Test Results Task finished successfully.");
        return builder.build();
    }

    private void logUploadResult(BuildLogger buildLogger, UploadResult uploadResult) {
        int statusCode = uploadResult.getStatusCode();
        String serverResponse = StringUtils.defaultString((String)uploadResult.getMessage());
        String logMessage = String.format("Xray response: (%d) %s", statusCode, serverResponse);
        buildLogger.addBuildLogEntry(logMessage);
    }

    private File getReportFile(TaskResultBuilder builder, TaskContext taskContext, String filePath) throws IOException {
        if (filePath == null || StringUtils.isEmpty((CharSequence)filePath)) {
            filePath = "features/result.json";
        }
        return this.getFile(builder, taskContext, filePath);
    }

    private File getFile(TaskResultBuilder builder, TaskContext taskContext, String filePath) throws IOException {
        File file = new File(taskContext.getRootDirectory(), filePath);
        if (file.isDirectory() || !file.exists()) {
            builder.failed();
            taskContext.getBuildLogger().addBuildLogEntry("Import Test Results Task failed.");
            throw new IOException("File path is a directory or the file doesn't exist");
        }
        return file;
    }
}

